<?php
namespace ATEC;
defined('ABSPATH') || exit;

final class SVG
{

	private static $svg = 
	[
		// LOGOS
		
		'apache' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M20.797 1.005a.96.96 0 0 0-.525.143l.002-.004a11 11 0 0 0-2.164 2.175l-.02.028.001.003-.195.239c-.246.306-.504.637-.766.987a50 50 0 0 0-2.519 3.711l-.028.047.819 1.616-.822-1.619-.055.087q-.39.637-.771 1.302-.72 1.254-1.365 2.549l-.117.241a29 29 0 0 0-1.508 3.641l-.064.216a21 21 0 0 0-.624 2.346l-.026.15 1.12 2.212q.22-.594.455-1.203l.134-.331c.197-.507.399-1.012.604-1.531.195-.492.4-.987.605-1.487a115 115 0 0 1 1.999-4.504l.256-.53c.15-.304.296-.606.45-.905a.2.2 0 0 1 .025-.05v.003q.355-.71.72-1.397l.002.004q.77-1.438 1.632-2.824l.05-.08q.42-.66.846-1.275v-.001a21 21 0 0 1 1.84-2.31l-.014.016.072-.077a1 1 0 0 0-.07.076l-.001.002c-.598.69-1.165 1.45-1.672 2.251l-.046.077h-.005.007c-.255.387-.53.825-.825 1.325l-.05.077a65 65 0 0 0-2.302 4.294l2.833-.312a3.45 3.45 0 0 0 1.545-1.209l.007-.011q.147-.212.287-.427c.287-.454.575-.953.829-1.45.246-.482.462-.958.631-1.387q.157-.414.247-.75a8 8 0 0 0 .124-.558l.202-.034-.2.03a3.5 3.5 0 0 0-.324-2.68c-.003-.007-.545-.88-1.266-.902m1.267.902.002.003-.009-.017zm-.388 2.801c-.771.12-1.638.22-2.516.285l-.094.005a34 34 0 0 0 2.61-.29m-1.477 5.169a1 1 0 0 1-.113.079l-.004.002c-.36.193-.777.34-1.218.421l-.026.004-.001-.001h-.021l-.125.021.021-.01-2.83.312-.016.027.002-.005-.096.2c-.097.2-.196.4-.295.61l-.325.69-.165.359a93 93 0 0 0-1.783 4.124q-.307.744-.616 1.537c-.187.475-.37.956-.562 1.455l-.025.075a147 147 0 0 0-.566 1.525l-.01.027q-.044.114-.084.229l-.002.003q-.219.605-.444 1.24l-.006.019-.062.177c-.1.284-.187.54-.387 1.125.37.241.66.578.838.977l.006.014a1.8 1.8 0 0 0-.58-1.236l-.002-.001a3.88 3.88 0 0 0 3.729-1.51l.007-.01c.054-.09.113-.199.165-.312l.01-.023a1.55 1.55 0 0 1-1.499.55 4.38 4.38 0 0 0 2.18-1.773l.01-.018q.174-.286.35-.629a3.52 3.52 0 0 1-3.352 1.077l.023.004-.017.002q-.02-.002-.039-.006h.002a6.4 6.4 0 0 0 3.433-1.929l.004-.004a8.6 8.6 0 0 0 1.152-1.589l.022-.043c.246-.428.499-.945.72-1.478l.035-.094q.315-.758.6-1.647a3.2 3.2 0 0 1-.82.29l-.021.004a2.4 2.4 0 0 1-.329.056l-.012.001a3.95 3.95 0 0 0 2.093-2.025l.01-.025c-.345.242-.75.426-1.186.53l-.024.005a4 4 0 0 1-.217.037l-.05.007c.34-.14.633-.307.901-.506l-.005.004.01-.008-.005.004c.315-.24.577-.528.783-.855l.008-.013.079-.13.096-.192c.146-.282.301-.632.436-.992l.023-.07.038-.11c.059-.161.112-.355.15-.555zm-10.148 8.996c-.004.025-.012.05-.015.075l.003-.001a16 16 0 0 0-.289 2.058l-.003.056c0 .025-.005.05-.006.075a4.5 4.5 0 0 0-1.261-1.093l-.021-.011a6.2 6.2 0 0 1 1.251 2.851l.005.036a2.85 2.85 0 0 1-1.424-.244c.327.335.735.588 1.192.729l.02.005c-.652.13-1.22.424-1.68.836a3.55 3.55 0 0 1 1.992-.36 169 169 0 0 0-2.303 7.109.67.67 0 0 0 .453-.438l.001-.005c.137-.46 1.05-3.482 2.472-7.454l.156-.435q.226-.623.467-1.275l.112-.296v-.005zm-2.228 5.372-.002.001-.003.003zm.468-1.57-.018-.007zm4.821-.104"/>'
		],
		
		'apple' => [
			'box' => '0 0 814 1000',
			'body' => '<path d="M788.1 340.9c-5.8 4.5-108.2 62.2-108.2 190.5 0 148.4 130.3 200.9 134.2 202.2-.6 3.2-20.7 71.9-68.7 141.9-42.8 61.6-87.5 123.1-155.5 123.1s-85.5-39.5-164-39.5c-76.5 0-103.7 40.8-165.9 40.8s-105.6-57-155.5-127C46.7 790.7 0 663 0 541.8c0-194.4 126.4-297.5 250.8-297.5 66.1 0 121.2 43.4 162.7 43.4 39.5 0 101.1-46 176.3-46 28.5 0 130.9 2.6 198.3 99.2m-234-181.5c31.1-36.9 53.1-88.1 53.1-139.3A96 96 0 0 0 605.3 0c-50.6 1.9-110.8 33.7-147.1 75.8-28.5 32.4-55.1 83.6-55.1 135.5 0 7.8 1.3 15.6 1.9 18.1 3.2.6 8.4 1.3 13.6 1.3 45.4 0 102.5-30.4 135.5-71.3"/>'
		],
		
		'apcu' => [
			'box' => '0 0 640 640',
			'body' => '<path d="M0 0h640v640H0z" fill="#000"/><path d="M171 355h-50l-15 28H80l71-125h29l20 125h-24zm-3-21l-7-50-30 50zm73 49h-26l26-125h51c9 0 16 1 22 3 5 2 9 6 13 11 3 5 5 11 5 18 0 6-1 12-4 18-2 6-5 11-9 14-4 4-7 6-12 8-4 2-10 3-17 4-4 1-12 1-23 1h-16zm15-69h8c14 0 23-1 27-3 5-2 8-4 11-8s4-8 4-12c0-3-1-5-2-7s-3-3-6-4c-2-1-8-1-16-1h-18zm167 23l26 4c-5 14-13 25-23 32s-22 11-36 11c-15 0-27-5-36-14s-13-23-13-40c0-14 3-27 9-39s14-21 24-27 21-9 34-9c14 0 25 4 33 11s13 17 15 30l-25 2c-1-7-4-13-8-16s-9-5-16-5-14 2-20 6-11 11-15 20-6 18-6 28 2 18 7 23 11 8 18 8 13-2 18-6c7-4 11-10 14-19zm54-45h25l-11 54c-1 6-2 10-2 12 0 3 1 5 3 7s4 3 7 3c2 0 4 0 6-1s4-2 6-4l6-6c2-2 3-5 5-9 1-3 2-7 4-13l9-43h25l-19 91h-23l3-12c-10 10-21 14-33 14-7 0-13-2-18-6s-6-10-6-17c0-3 1-9 3-19z" fill="#fff"/>'
		],
		
		'curl' => [
			'box' => '0 0 24 20.011',
			'body' => '<path d="M.803 12.843a.967.967 0 1 1 1.933 0 .967.967 0 0 1-1.933 0m2.736 0c0-.196-.053-.376-.112-.553-.234-.702-.876-1.216-1.657-1.216-.125 0-.235.046-.353.07C.615 11.312 0 11.991 0 12.843a1.77 1.77 0 0 0 3.539 0m-1.77-7.149a.967.967 0 1 1 0 1.934.967.967 0 0 1 0-1.934m0 2.736a1.77 1.77 0 0 0 1.77-1.77c0-.195-.053-.376-.112-.552-.234-.702-.877-1.217-1.657-1.217-.125 0-.235.047-.353.072C.615 5.13 0 5.808 0 6.66c0 .977.792 1.77 1.77 1.77m13.22-5.694a.966.966 0 0 1-.966-.967.966.966 0 0 1 .967-.966.967.967 0 1 1 0 1.933m-9.6 16.513a.967.967 0 0 1 0-1.933.966.966 0 0 1 .966.967.966.966 0 0 1-.966.966M14.991 0a1.77 1.77 0 0 0-1.77 1.77c0 .208.053.402.119.588L5.039 16.584c-.803.168-1.418.846-1.418 1.699a1.77 1.77 0 0 0 3.539 0 1.7 1.7 0 0 0-.111-.553l8.343-14.273c.778-.186 1.368-.853 1.368-1.688A1.77 1.77 0 0 0 14.99 0m7.24 2.736a.966.966 0 0 1-.966-.967.966.966 0 0 1 .967-.966.967.967 0 1 1 0 1.933m-9.6 16.513a.966.966 0 0 1-.966-.967.966.966 0 0 1 .966-.966.967.967 0 0 1 0 1.933M22.231 0a1.77 1.77 0 0 0-1.77 1.77c0 .208.053.402.119.588l-8.301 14.226c-.802.168-1.417.846-1.417 1.699a1.77 1.77 0 0 0 3.538 0c0-.197-.053-.376-.111-.553l8.343-14.273C23.409 3.271 24 2.604 24 1.769A1.77 1.77 0 0 0 22.23 0"/>' 
		],
		
		'gd' => [
			'box' => '0 0 512 512',
			'body' => '<path d="m216.919 72.633c-14.914-12.448-36.853-11.458-50.592 2.281l-91.429 91.418c-13.729 13.739-14.707 35.678-2.27 50.592l246.308 295.071 193.064-193.053z"/><path d="m89.743 5.493c-7.33-7.32-19.21-7.32-26.539.01l-57.706 57.707c-7.33 7.329-7.33 19.21 0 26.528l56.934 56.934 84.245-84.236z"/>'
		],
		
		'imagick' => [
		'box' => '0 0 15.16 15.16',
		'body' => '<path d="m11.65 10.8-.08-.04-3.62-9.58.01-.02.13-.04a.8.8 0 0 1 .8.48c.4 1.18 1.22 1.25 1.22 1.25s-.8-.3-1.01-1.13c-.12-.47-.45-.7-.45-.7a1 1 0 0 0-.58-.2l-.1.02.07-.06a.6.6 0 0 1 .71.11q.34.38.63.48c.42.66.98.7.98.7s-.48-.18-.8-.64c.25.05.42 0 .42 0s-.22 0-.47-.09a2 2 0 0 1-.19-.43c-.12-.47-.46-.7-.46-.7A1 1 0 0 0 8.27 0c-.25 0-.46.17-.58.34l-.1.15c-.07.07-.42.81-.42.81l-.12.3-.03.06c-.57 1.44-2.54 6.37-3.6 9.19-.9.38-2.54 1.25-2.34 2.39.16.87 1.09 1.7 6.84 1.92h.36c2.16 0 5.42-.24 5.78-1.67.28-1.1-1.14-2.02-2.41-2.7M8.16.35 8.3.3a.8.8 0 0 1 .82.5q.1.26.2.45a1 1 0 0 1-.38-.33c-.21-.3-.52-.37-.52-.37a.7.7 0 0 0-.43.01zm-.35 13.6c-4.87.09-5.48-1-5.61-1.14.05-.12.33-.3.6-.48l-.08.27c-.1.71 8.63 1.46 9.63 0l-.1-.25c.57.4.64.61.65.61-.25.44-2.03.95-5.09 1"/>'
		],

		'linux' => [
			'box' => '0 0 24.7 29.995',
			'body' => '<path d="M11.272 7.076c-.025.072-.141.061-.207.082-.059.031-.107.085-.175.085-.062 0-.162-.025-.17-.085-.012-.082.11-.166.187-.166a.391.391 0 0 1 .326-.005l-.003-.001a.06.06 0 0 1 .038.055l-.001.008v.025h.004zm.688 0v-.027c-.008-.025.016-.052.036-.062a.396.396 0 0 1 .327.006l-.002-.001c.079 0 .2.084.187.169-.007.061-.106.082-.169.082-.069 0-.115-.054-.176-.085-.065-.023-.182-.01-.204-.081zm1.352 1.978a4.608 4.608 0 0 1-1.835.666l-.024.003a2.933 2.933 0 0 1-1.607-.588l.007.005c-.192-.167-.35-.335-.466-.419-.205-.167-.18-.416-.092-.416.136.02.161.167.249.25.12.082.269.25.45.416.397.328.899.541 1.45.583l.009.001a3.915 3.915 0 0 0 1.763-.592l-.016.01c.244-.169.556-.417.81-.584.195-.17.186-.334.349-.334.16.02.043.167-.184.415a9.973 9.973 0 0 1-.818.56l-.044.025z"/>'
		],
		
		'litespeed' => [
			'box' => '0 0 800 800',
			'body' => '<path fill="#818181" d="M702.5 398.3 531.6 227.4a4 4 0 0 0-2.7-1h-.2a4 4 0 0 0-2.7 1.4l-73 92.4a4 4 0 0 0 .3 5l78.5 78.5a15 15 0 0 1 4.4 10.5q-.1 6.2-4.4 10.5l-22.7 22.6a4 4 0 0 0-.4 4.8c5.6 8.5 14.9 22.4 15.7 24 2.9 5.6 3.8 20.1-4.5 26.5L341.4 639.7a4 4 0 0 0-1.4 3v138.6c0 2.7 0 4.3 2 5.3l1.7.4c1.6 0 2.2-.6 3.7-2.1l3-3 11.3-11.3 40.4-40.3L524.5 608l178-178c8.6-8.7 8.6-23 0-31.7"/><path fill="#3C3C3A" d="m475.4 32.7-.1-.2-.1-.1a4 4 0 0 0-2.8-1.4h-.1q-1.6 0-2.7 1.1l-356 356A22 22 0 0 0 107 404a22 22 0 0 0 6.6 15.8l170.8 170.8a4 4 0 0 0 2.7 1.1h.2a4 4 0 0 0 2.8-1.4l72.9-92.4a4 4 0 0 0-.3-5L284 414.3a15 15 0 0 1-4.3-10.4c0-4 1.5-7.8 4.3-10.5l22.7-22.8a4 4 0 0 0 .5-4.8l-15.5-22.3a20.7 20.7 0 0 1 4.3-28.1l178.6-137a4 4 0 0 0 1.4-3l.1-140.5q0-1.2-.8-2.3"/><path fill="#BFBFBF" d="M506.9 473.7 309 345.3 396.5 471a10 10 0 0 1-.4 10.5L239.7 680c-2.8 3.6-5.1 7.5-3.2 11.5a8 8 0 0 0 6.1 4c3.1 0 5.5-1.4 8.7-3.9l251.4-193c7.7-5.9 7.5-20 4.2-24.9"/><path fill="#D3D3D3" d="M579.5 126.6a7 7 0 0 0-6.6-4c-2.4 0-4.7 1-8.2 3.7L313.2 319.4c-8 6.1-9.8 17.7-4 26l197.7 128.3-87.4-126.6a10 10 0 0 1 .3-10.6L576.3 138v-.1c2.6-3.3 5.2-7 3.2-11.2"/>'
		],
		
		'memcached' => [
			'box' => '0 0 18 18',
			'body' => '<g transform="matrix(.00962 0 0 -.00962 -.8 18.2)"><path d="M165 1828c-28-171-62-533-76-813-11-233-7-787 7-903l7-52h454l-13 67c-18 97-71 501-89 682-17 179-19 427-2 490 15 55 40 74 62 46 49-65 202-430 344-821l22-61h286l13 36c145 411 329 844 366 858 74 28 81-256 19-755-25-201-59-444-71-508l-6-34h451l8 58c12 92 9 899-5 1082-12 151-55 550-67 628l-6 32h-445l-36-37c-44-47-117-147-231-318-48-71-98-143-111-160-25-30-25-30-44-10-11 11-68 92-128 180-130 194-207 298-241 325-24 19-41 20-244 20H171Z"/><path d="M764 251c-44-27-60-77-41-124 19-45 52-67 102-67 70 0 117 68 95 135-23 70-93 95-156 56m394 0c-31-25-52-81-43-113 4-13 19-35 33-50 20-22 35-28 68-28 78 0 130 73 101 142-19 45-39 60-90 65-32 4-48 0-69-16"/></g>'
		],
		
		'mariadb' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M27.21 7.64a1.1 1.1 0 0 0-1.17.84v.01a.9.9 0 0 0 1.47-.84l-.24-.01zm2.58-.37q-.03.01-.09.1a3 3 0 0 0-.41 1.5c0 .2.1.12.1-.01q.02-.82.42-1.47.04-.12-.02-.12m-.13-.11q-.04 0-.1.1a3.5 3.5 0 0 0-.64 1.6v.01c-.02.2.09.12.1 0a3.4 3.4 0 0 1 .65-1.6v.02q.05-.13-.01-.13m-.12-.15q-.03 0-.1.09a4 4 0 0 0-.96 1.67v.03c-.04.2.07.12.1 0a4 4 0 0 1 .95-1.67q.06-.11 0-.12m-.1-.17a.2.2 0 0 0-.12.07 6 6 0 0 0-1.21 1.78l-.01.04c-.07.2.06.14.1.01a6 6 0 0 1 1.21-1.77q.08-.11.03-.13m.18-.24c.12.38.3.56 1.05.63a2.9 2.9 0 0 1-1.46 2h-.01a6 6 0 0 0-1.77 1.56l-.01.01a27 27 0 0 0-1.86 5l-.04.2a8.8 8.8 0 0 1-2.84 4.75c-.2-.44.2-.7.03-1.11-.34.83-.67 1.5-1.04 2.17l.05-.1a6.7 6.7 0 0 1-4.83 3.7h-.04a10 10 0 0 0 2.37-5.75v-.03c-.5.1-.54 1.46-1.35 1.95h-.22q-.92 0-1.8-.16h.06a15 15 0 0 0-2.5-.2 15 15 0 0 0-3.97.53l.1-.02a45 45 0 0 0-4.29 2.42l.18-.1a6 6 0 0 1-2.79.64q-.42 0-.82-.06h.03c-.22-.29 1.25-.66 1.17-1.3-.67-.07-1.06.09-1.64-.18a1 1 0 0 1 .27-.3c1.07-.73 4.1-.17 4.91-.97a9 9 0 0 0 1.15-1.47l.02-.03q.5-.8 1.18-1.38h.01c.2-.16.5-.43.72-.58a12 12 0 0 1 2.87-1.4l.1-.02c1.46-.52 2.94-.69 4.5-1.29a11 11 0 0 0 2.78-1.38l-.03.02q.38-.28.69-.58c2.77-2.74 2.95-6.47 6.76-6.86.46-.05.84-.03 1.19-.04h.04q.6 0 1.1-.28zm.72-.56c-.46.02-.33.23-1.32.47a20 20 0 0 0-3.45.58l.14-.03c-2.84 1.2-3.3 5.78-6.67 7.56-1.86.9-4.03 1.64-6.29 2.13l-.2.04a12 12 0 0 0-3.83 2.12l.02-.02c-.92.8-1.14 1.57-2.1 2.56-.98 1.33-4.68.15-5.64 1.81a2 2 0 0 0 1.7.3h-.02c-.18.35-1.34.8-1.13 1.31q.56.1 1.22.1a8 8 0 0 0 3.99-1.03l-.04.02a13 13 0 0 1 3.75-1.6l.1-.03h.08q3.9 0 7.57.72l-.25-.04a22 22 0 0 1-1.78 2.7l.04-.05c-.19.2.16.39.81.26a8 8 0 0 0 2.9-1.2l-.04.02a12 12 0 0 0 2.48-2.52l.02-.03c.8 1.29 3.64 1.57 4.23.46-1.09-.46-1.32-2.85-.95-3.88.4-.99.77-2.2 1.07-3.46l.04-.2c.32-1.16.52-2.93.9-3.84.45-1.13 1.34-1.48 2-2.08A2.9 2.9 0 0 0 31 6.8v-.07q-.01-.68-.65-.67z"/>'
		],
		
		'mysql' => [
			'box' => '0 0 24 24',
			'body' => '<path d="m24.1 23.4-.5-.5-.8-.9-1-.7-1-.7-.8-.8.5-.2.6-.1.8-.1.8-.2h.4l.4-.2v-.2l-.4-.5-.4-.4-1.4-1.1-1.3-1-.9-.4-.9-.4-.3-.1-.3-.2-.4-.6-.3-.7-.7-1.4q-.4-.7-.6-1.5l-.4-1-.5-.9-1.3-1.9L12 5.1l-1.7-1.3-2-1.3-1-.4-1-.3H4.8l-.3-.4-.4-.3-2-.9H2A1 1 0 0 0 .9 0a1 1 0 0 0-.8.8 2 2 0 0 0 .2 1.6l.9 1.1.4.6.4.7.1.4.2.5.4 1.1.5 1.1.2.5.3.5.3.2.2.4-.3.5-.1.7-.4 2.2v.8q.1 1.4.9 2.6l.6.7a1 1 0 0 0 1.1.2 1 1 0 0 0 .6-.8l.2-1.3V15q0-.2.2-.3l.3.7.3.7q.4.7 1 1.2l1.1 1 .6.6.6.4-.2-.2-.2-.1-.4-.5-.4-.5-1-1.5-.9-1.6-.4-.8-.3-.8L7 13l-.2-.3-.4.6-.4.6-.3 1.1-.1 1.4-.7-.4-.3-.7-.4-2.2a6 6 0 0 1 .3-2.3l.3-.8q.3-.6 0-1l-.2-.3-.3-.4-.4-.5-.2-.5L3.2 6l-.6-1.6-.3-.6-.5-.6-.5-.6L1 2l-.1-.4v-.3L1 1h.2l.5-.1.6.2.8.4.8.4.3.3.4.3h1.2q.5 0 .8.2l1.3.5 1 .6q1 .5 1.6 1.1l1.4 1.4L13 7.8l1 1.7.3.6.2.6.6 1.2.5 1.2.6 1.2.6 1q.3.4.8.5t1 .3l.4.2.6.2.9.6.8.5.7.5q.5.3.4.5h-1.8l-1.4.5h-.4l-.3.3.2.3.1.3.4.5.5.5.5.4.5.4 1 .4 1 .6.6.4.6.4.2.2.3.2-.2-.3zM5.6 4.2h-.7v.1l.3.3.2.4.4.8.3-.4.1-.4v-.1l-.1-.1v-.2l-.3-.2z"/>'
		],
		
		'nginx' => [
			'box' => '0 0 16 16',
			'body' => '<path d="M7.62.102a.757.757 0 0 1 .76 0l6.246 3.625a.75.75 0 0 1 .374.648v7.25a.75.75 0 0 1-.374.648L8.38 15.898a.757.757 0 0 1-.76 0l-6.246-3.625A.75.75 0 0 1 1 11.625v-7.25a.75.75 0 0 1 .374-.648L7.62.102zM2.508 4.806v6.388L8 14.382l5.492-3.188V4.806L8 1.618 2.508 4.806zm2.475-.249a.757.757 0 0 1 .822.163l4.241 4.22V5.25c0-.414.338-.75.754-.75s.754.336.754.75v5.5a.75.75 0 0 1-.466.693.757.757 0 0 1-.821-.163L6.026 7.06v3.69c0 .414-.338.75-.754.75a.752.752 0 0 1-.754-.75v-5.5a.75.75 0 0 1 .465-.693z"/>'
		],

		'php' => [
			'box' => '0 0 640 512',
			'body' => '<path d="M320 104.5c171.4 0 303.2 72.2 303.2 151.5S491.3 407.5 320 407.5c-171.4 0-303.2-72.2-303.2-151.5S148.7 104.5 320 104.5m0-16.8C143.3 87.7 0 163 0 256s143.3 168.3 320 168.3S640 349 640 256 496.7 87.7 320 87.7M218.2 242.5c-7.9 40.5-35.8 36.3-70.1 36.3l13.7-70.6c38 0 63.8-4.1 56.4 34.3M97.4 350.3h36.7l8.7-44.8c41.1 0 66.6 3 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1q-14.6-16.7-46.5-16.7h-70.7zm185.7-213.6h36.5l-8.7 44.8c31.5 0 60.7-2.3 74.8 10.7 14.8 13.6 7.7 31-8.3 113.1h-37c15.4-79.4 18.3-86 12.7-92-5.4-5.8-17.7-4.6-47.4-4.6l-18.8 96.6h-36.5zM505 242.5c-8 41.1-36.7 36.3-70.1 36.3l13.7-70.6c38.2 0 63.8-4.1 56.4 34.3M384.2 350.3H421l8.7-44.8c43.2 0 67.1 2.5 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1q-14.6-16.7-46.5-16.7H417z"/>'
		],
		
		'primer' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M25.5 5.2h-.3V2.7q0-.6-.7-.7l-.4.1H24l-1.6.1H9.7L9.4 2q-.7 0-.8.8v2.5H6.8l-.4.1q-.7.1-.8.8L5.7 9v2.7l.5.4 1.8.2q.8 0 1.7.3l1.7.2h.2-.2.4l1.5.3 1.8.2h1v1.9h-1.7q-.4 0-.6.4-.6.1-.7.8v5l-.2 4.8V29q0 .6.6.8l.6.2 1.5-.1H17l2.7-.1h.2q.3 0 .5-.3l.2-.5v-4l-.2-2.4-.1-2.4v-4.1q0-.6-.6-.8l-.4-.1h-1.7l.1-2.3q0-.5-.4-.7-.3-.4-.7-.4l-1.3-.1-4.4-.5q-1 0-2.1-.4l-1.5-.2V7h1.3v2.3q.1.7.8.8H19l1.3.1h3.8l.4.2q.7 0 .8-.7V8.4l-.1-1.5h.3q.8 0 .9-.9 0-.7-.9-.8m-6.8 11.6v2l.2 2.4v7.1h-4.4v-8.5l.1-3zm3.3-8h-7l-2.7-.2h-2.1V3.7h13.6v5zm-5.2 16.8q.4 0 .5.5t-.6.6q-.7 0-.5-.6 0-.5.5-.5"/>'
		],
		
		'redis' => [
			'box' => '0 -2 18 18',
			'body' => '<path d="M17.997 9.965q-.013.25-.707.604c-.964.502-5.932 2.552-6.992 3.098a2.4 2.4 0 0 1-1.362.43 2.6 2.6 0 0 1-1.131-.29l.006.008c-.835-.4-6.124-2.54-7.081-2.995q-.714-.334-.727-.598v1.819q.007.263.727.598c.957.456 6.246 2.596 7.081 2.994a2.3 2.3 0 0 0 1.125.283q.777-.013 1.368-.437l-.006.006c1.06-.552 6.034-2.596 6.992-3.097.488-.257.707-.45.707-.63z"/><path d="M17.997 7.003q-.013.244-.707.604c-.964.5-5.932 2.55-6.992 3.097a2.4 2.4 0 0 1-1.362.43q-.624 0-1.131-.288l.006.006C6.976 10.454 1.687 8.314.73 7.858Q.016 7.523.003 7.26v1.819q.007.263.727.597c.957.45 6.246 2.596 7.081 2.995a2.3 2.3 0 0 0 1.125.283q.777-.013 1.368-.437l-.006.006c1.06-.553 6.034-2.596 6.992-3.097.488-.257.707-.45.707-.63z"/><path d="M17.993 3.925q0-.27-.713-.52c-.938-.341-5.886-2.314-6.83-2.661A2.6 2.6 0 0 0 9.291.5q-.706.006-1.304.32l.02-.005c-1.119.398-6.382 2.46-7.32 2.827Q0 3.912 0 4.182v1.812q.013.27.726.604c.958.45 6.253 2.596 7.088 2.995a2.3 2.3 0 0 0 1.119.282c.514 0 .983-.167 1.368-.437 1.054-.546 6.028-2.596 6.992-3.097.488-.257.707-.45.707-.63v-1.8h-.013ZM6.44 5.64l4.164-.643-1.26 1.85Zm9.222-1.658-2.731 1.08-2.455-.984 2.724-1.08ZM8.418 2.196l-.404-.745 1.26.495 1.187-.386-.321.765 1.208.45-1.562.16-.347.842-.565-.932-1.8-.167ZM5.321 3.244c1.234 0 2.23.385 2.23.867s-.996.86-2.23.86-2.23-.384-2.23-.86c0-.475.996-.867 2.23-.867"/>'
		],
		
		'sqlite' => [
			'box' => '0 0 6.554 6.555',
			'body' => '<path d="M4.96.29H.847c-.276 0-.5.226-.5.5v4.536c0 .276.226.5.5.5h2.71c-.03-1.348.43-3.964 1.404-5.54z" fill="#909090"/><path d="M4.81.437H.847a.356.356 0 0 0-.355.355v4.205c.898-.345 2.245-.642 3.177-.628A29 29 0 0 1 4.811.437z" fill="#8f8f8f"/><path d="M5.92.142c-.282-.25-.623-.15-.96.148l-.15.146c-.576.61-1.1 1.742-1.276 2.607a2.4 2.4 0 0 1 .148.426l.022.1.022.102s-.005-.02-.026-.08l-.014-.04-.009-.022a5 5 0 0 0-.187-.352 9 9 0 0 0-.103.321c.132.242.212.656.212.656s-.007-.027-.04-.12c-.03-.083-.176-.34-.21-.4-.06.22-.083.368-.062.404.04.07.08.2.115.324a8 8 0 0 1 .132.666l.005.062a6 6 0 0 0 .015.75c.026.313.075.582.137.726l.042-.023c-.09-.284-.128-.655-.112-1.084.025-.655.175-1.445.454-2.268C4.548 1.938 5.2.94 5.798.464c-.545.492-1.282 2.084-1.502 2.673-.247.66-.422 1.28-.528 1.873.182-.556.77-.796.77-.796s.29-.356.626-.865l-.645.172-.208.092s.53-.323.987-.47c.627-.987 1.31-2.39.622-3.002"/>'
		],

		'ubuntu' => [
			'box' => '0 0 20 20',
			'body' => '<path d="M15.61 3.45c.92.5 2.1.2 2.62-.68a1.8 1.8 0 0 0-.7-2.52 1.96 1.96 0 0 0-2.62.67c-.53.89-.21 2.02.7 2.53M11.7 15.4a6 6 0 0 1-2.36-.5L8 17.2a8.6 8.6 0 0 0 5.92.54 2.6 2.6 0 0 1 1.31-1.83 2.8 2.8 0 0 1 2.3-.18A8 8 0 0 0 20 10.52l-2.73-.04a5.5 5.5 0 0 1-5.58 4.92m0-10.8a5.53 5.53 0 0 1 5.58 4.92L20 9.48a8 8 0 0 0-2.48-5.2 2.8 2.8 0 0 1-2.3-.19 2.6 2.6 0 0 1-1.3-1.83 9 9 0 0 0-2.23-.29q-2 .02-3.7.83l1.34 2.3a6 6 0 0 1 2.36-.5M6.09 10c0-1.83.94-3.44 2.38-4.42l-1.4-2.26a8 8 0 0 0-3.45 4.67c.6.47 1 1.2 1 2.01s-.4 1.54-1 2.01a8 8 0 0 0 3.45 4.67l1.4-2.26A5.3 5.3 0 0 1 6.08 10m9.54 6.55a1.8 1.8 0 0 0-.7 2.53c.52.88 1.7 1.18 2.61.67a1.8 1.8 0 0 0 .7-2.52 1.96 1.96 0 0 0-2.62-.68M1.92 8.15C.86 8.15 0 8.98 0 10s.86 1.85 1.92 1.85 1.92-.83 1.92-1.85-.86-1.85-1.92-1.85" fill-rule="evenodd"/>'
		],

		'windows' => [
			'box' => '0 0 448 512',
			'body' => '<path d="m0 93.7 183.6-25.3v177.4H0zm0 324.6 183.6 25.3V268.4H0zm203.8 28L448 480V268.4H203.8zm0-380.6v180.1H448V32z"/>'
		],

		'woocommerce' => [
			'box' => '0 0 25 24',
			'body' => '<path fill="#022639" fill-rule="evenodd" d="M1.46 7.5c0-1.1.9-2 2-2h18a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H15.7l1.25 3.12-5.62-3.12H3.46a2 2 0 0 1-2-2zm10.3.18a.75.75 0 1 0-1.35-.66c-.79 1.61-1.2 3.3-1.32 5.02q-.6-1.34-.74-2.91a.75.75 0 0 0-1.4-.29l-2 3.72c-.27-1.15-.6-2.85-.84-5.03a.75.75 0 1 0-1.5.17 47 47 0 0 0 1.24 6.64l.1.36.05.12a.75.75 0 0 0 1.37.12l1.89-3.52a9.4 9.4 0 0 0 2.05 3.67.75.75 0 0 0 1.3-.57c-.21-2.42.1-4.7 1.15-6.84m2 1.69c-.29.28-.55.73-.67 1.3s-.05 1.1.11 1.46c.17.37.4.53.58.57.2.04.46-.02.76-.3q.47-.43.67-1.3c.12-.57.05-1.1-.11-1.46-.16-.37-.39-.53-.58-.57-.2-.04-.46.02-.76.3m-1.03-1.1a2.4 2.4 0 0 1 2.09-.67c.8.16 1.35.75 1.65 1.44s.38 1.52.21 2.36a4 4 0 0 1-1.11 2.09c-.54.51-1.28.84-2.08.68a2.4 2.4 0 0 1-1.66-1.44 4 4 0 0 1-.2-2.36c.16-.84.56-1.58 1.1-2.1m6.1 2.5c.12-.6.39-1.07.68-1.36s.55-.34.71-.3c.16.02.37.17.53.55s.21.91.1 1.5c-.13.6-.4 1.07-.68 1.36-.3.3-.55.34-.71.31s-.38-.17-.53-.56a2.7 2.7 0 0 1-.1-1.5m1.69-3.14a2.3 2.3 0 0 0-2.07.72 4 4 0 0 0-1.09 2.12c-.17.84-.1 1.68.18 2.37s.82 1.3 1.62 1.46 1.54-.2 2.06-.71c.53-.53.92-1.28 1.1-2.12a4 4 0 0 0-.18-2.38 2.3 2.3 0 0 0-1.62-1.46" clip-rule="evenodd"/>'
		],

		// OTHER
		
		'blog' => [
				'box' => '0 0 512 512',
				'body' => '<path d="M192 32c0 17.7 14.3 32 32 32 123.7 0 224 100.3 224 224 0 17.7 14.3 32 32 32s32-14.3 32-32C512 128.9 383.1 0 224 0c-17.7 0-32 14.3-32 32m0 96c0 17.7 14.3 32 32 32 70.7 0 128 57.3 128 128 0 17.7 14.3 32 32 32s32-14.3 32-32c0-106-86-192-192-192-17.7 0-32 14.3-32 32m-96 16c0-26.5-21.5-48-48-48S0 117.5 0 144v224c0 79.5 64.5 144 144 144s144-64.5 144-144-64.5-144-144-144h-16v96h16c26.5 0 48 21.5 48 48s-21.5 48-48 48-48-21.5-48-48z"/>'
			],
		
		'bug' => [
			'box' => '0 0 18 18',
			'body' => '<path d="M18 10.157c-.017.612-.535 1.093-1.148 1.093h-1.946v.562a5 5 0 0 1-.478 2.15l2.118 2.118a1.125 1.125 0 0 1-1.592 1.59l-1.924-1.924a5.04 5.04 0 0 1-3.186 1.129V8.297a.42.42 0 0 0-.422-.422h-.844a.42.42 0 0 0-.422.422v8.578a5.04 5.04 0 0 1-3.186-1.129l-1.925 1.925a1.125 1.125 0 0 1-1.59-1.591l2.117-2.118a5 5 0 0 1-.478-2.15v-.562H1.148A1.14 1.14 0 0 1 0 10.157 1.125 1.125 0 0 1 1.125 9h1.969V6.935l-1.64-1.64a1.125 1.125 0 0 1 1.591-1.59l1.921 1.92h8.068l1.92-1.92a1.125 1.125 0 0 1 1.591 1.59l-1.639 1.64V9h1.969c.632 0 1.142.52 1.125 1.157M9.035 0a3.937 3.937 0 0 0-3.937 3.937h7.875A3.937 3.937 0 0 0 9.035 0"/>'
		],
		
		'calendar' => [
		'box' => '0 0 122.9 122.9',
		'body' => '<path d="M81.6 4.7c0-2.6 2.6-4.7 5.8-4.7S93 2.1 93 4.7v20.8c0 2.6-2.5 4.7-5.7 4.7s-5.8-2.1-5.8-4.7zm-15.5 101c-.8 0-.8-10.1 0-10.1H82c.8 0 .8 10 0 10ZM16 68.9c-.8 0-.8-10 0-10h15.7c.8 0 .8 10 0 10Zm25 0c-.7 0-.7-10 0-10h15.9c.8 0 .8 10 0 10Zm25.2 0c-.8 0-.8-10 0-10H82c.8 0 .8 10 0 10Zm25.2-10H107c.8 0 .8 10 0 10H91.3c-.8 0-.8-10 0-10M15.8 87.2c-.9 0-.9-10.1 0-10.1h15.7c.8 0 .8 10.1 0 10.1Zm25.1 0c-.8 0-.8-10.1 0-10.1h15.8c.8 0 .8 10.1 0 10.1Zm25.1 0c-.8 0-.8-10.1 0-10.1h16c.8 0 .8 10.1 0 10.1Zm25.2 0c-.8 0-.8-10.1 0-10.1H107c.8 0 .8 10.1 0 10.1Zm-75.4 18.4c-.8 0-.8-10.1 0-10.1h15.7c.8 0 .8 10 0 10Zm25.1 0c-.8 0-.8-10.1 0-10.1h15.8c.8 0 .8 10 0 10ZM29.6 4.7c0-2.6 2.6-4.7 5.8-4.7s5.8 2.1 5.8 4.7v20.8c0 2.6-2.6 4.7-5.8 4.7s-5.8-2.1-5.8-4.7zM6.4 43.5h110v-22a3 3 0 0 0-.8-2.1 3 3 0 0 0-2-.9H103a3.2 3.2 0 0 1 0-6.4h10.6a9.4 9.4 0 0 1 9.3 9.4v92a9.4 9.4 0 0 1-9.4 9.4H9.3a9.4 9.4 0 0 1-9.3-9.4v-92A9.4 9.4 0 0 1 9.3 12h11.3a3.2 3.2 0 1 1 0 6.4H9.3a3 3 0 0 0-2 .9 3 3 0 0 0-.9 2zm110 6.4H6.5v63.7a3 3 0 0 0 .9 2 3 3 0 0 0 2 .9h104.3a3 3 0 0 0 2-.9 3 3 0 0 0 .9-2zm-66-31.4a3.2 3.2 0 0 1 0-6.4H72a3.2 3.2 0 1 1 0 6.4Z"/>'
		],
		
		'classicpress' => [
			'box' => '0 0 593.2 593.2',
			'body' => '<path d="M296.6 0a296.6 296.6 0 1 0 0 593.2 296.6 296.6 0 0 0 0-593.2"/><path d="M462 130.5a8 8 0 0 0-6.3-3.2c-42.7 2.2-111.5 27.4-114.4 28.5a7 7 0 0 0-3.9 3.5l-9.7 19.3-7.2-7.1a7 7 0 0 0-8.2-1.3c-8.2 4.3-49.5 26.2-58.3 37-5.2 6.1-9.1 19.7-11.8 31.7l-4.7-9.4a7 7 0 0 0-4.9-3.7 7 7 0 0 0-6 1.6c-2.5 2.2-54.1 48.7-43.3 106.6 41.3-59 91-108.4 172.2-148.3a7 7 0 0 1 6.2 12.6l-13.9 7-3.4 1.9-10.2 5.7-3.2 1.8q-13 7.6-24.7 15.5l-2 1.4-10 7-1.7 1.3c-76.7 56.7-117.2 128.2-165.8 214.2a7 7 0 0 0 2.6 9.5 7 7 0 0 0 3.5 1 7 7 0 0 0 6.1-3.6 1583 1583 0 0 1 57-95.7 40 40 0 0 0 32.7 14.6c53.1 0 140.9-77.7 149.7-102.7a7 7 0 0 0-5-9.2l-23.3-5.8 51-8.5a7 7 0 0 0 5-3.8l56.3-112.4a8 8 0 0 0-.4-7" fill="#fff"/>'
		],

		'code' => [
			'box' => '0 0 640 512',
			'body' => '<path d="M392.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6zm80.6 120.1c-12.5 12.5-12.5 32.8 0 45.3l89.3 89.4-89.4 89.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-112-112c-12.5-12.5-32.8-12.5-45.3 0zm-306.7 0c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l112 112c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256l89.4-89.4c12.5-12.5 12.5-32.8 0-45.3z"/>'
		],
		
		'computer' => [
			'box' => '0 0 122.88 94.35',
			'body' => '<path d="M90.37 26.48h25.48a7 7 0 0 1 7.03 7.03v53.82a7 7 0 0 1-7.03 7.03H90.37a7 7 0 0 1-7.03-7.03V33.5a7 7 0 0 1 7.03-7.02M3.05 0h106.12a3.06 3.06 0 0 1 3.05 3.05v18.44h-6.48V8.44a2.7 2.7 0 0 0-2.7-2.7H9.17a2.7 2.7 0 0 0-2.7 2.7v52.53a2.7 2.7 0 0 0 2.7 2.7H76.7V76.4H3.05A3.06 3.06 0 0 1 0 73.35V3.05A3.06 3.06 0 0 1 3.05 0m39.22 80.61h27.67c.07 4.79 2.04 9.07 7.39 12.45H34.89c4.27-3.1 7.4-6.87 7.38-12.45m13.84-14.49a3.92 3.92 0 1 1 0 7.84 3.92 3.92 0 0 1 0-7.84m46.99 19.6a2.89 2.89 0 1 1 .01 5.77 2.89 2.89 0 0 1-.01-5.77m-16.8-2.2h33.61V37.37H86.3z" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		'database' => [
		'box' => '0 0 105.07 122.88',
		'body' => '<path d="M52.53 0C81.4 0 104.8 10.96 104.8 24.46S81.39 48.92 52.53 48.92.26 37.96.26 24.46 23.67 0 52.53 0M.26 81.83v18.78c9.3 33.03 101.18 26.65 104.55-1.69V80.16c-4.59 31.11-97.2 33.35-104.55 1.67M0 32.94v18.34c9.3 32.26 101.69 27.9 105.07.23V33.18C100.47 63.57 7.35 63.88 0 32.94m0 23.7v18.78c9.3 33.03 101.69 28.57 105.07.23V56.89C100.47 88 7.35 88.32 0 56.64" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		'disk' => [
		'box' => '0 0 106.45 122.88',
		'body' => '<path d="M27.03 0H78.2c10.61 0 18.1 8.75 19.28 19.28l7.71 68.38.04.19c.59 4.97 1.02 9.29 1.16 13.11.14 3.85-.02 7.15-.63 10l-.04.16a12.9 12.9 0 0 1-12.8 11.75h-79.8A12.9 12.9 0 0 1 .29 110.85l-.01-.46v-.07l-.11-3.52c-.16-4.77-.34-10.29.05-15.06l-.01.02L.3 91l.08-.76 7.37-70.96C8.84 8.73 16.43 0 27.03 0m76.87 103.37q0-1.11-.05-2.3c-.13-3.45-.51-7.43-1.04-11.99a8 8 0 0 0-2.79-.52H6.48q-1.86.02-3.42.8c-.56 3.9-.56 8.74-.45 13.33a12.9 12.9 0 0 1 10.52-5.5h79.8c4.63 0 8.71 2.48 10.97 6.18m-88.95 4.48h19.74v7.01H14.95z" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		'envelope-check' => [
		'box' => '0 0 640 512',
		'body' => '<path d="M48 64C21.5 64 0 85.5 0 112c0 15.1 7.1 29.3 19.2 38.4l217.6 163.2c11.4 8.5 27 8.5 38.4 0l57.4-43c23.9-59.8 79.7-103.3 146.3-109.8l13.9-10.4c12.1-9.1 19.2-23.3 19.2-38.4 0-26.5-21.5-48-48-48zm246.4 275.2a63.9 63.9 0 0 1-76.8 0L0 176v208c0 35.3 28.7 64 64 64h296.2c-25.1-30.4-40.2-69.5-40.2-112 0-5.6.3-11.1.8-16.6zM640 336a144 144 0 1 0-288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l28.7 28.7 60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"/>'
		],
		
		'envelopes-bulk' => [
		'box' => '0 0 640 512',
		'body' => '<path d="M128 0c-17.7 0-32 14.3-32 32v192h96v-32c0-35.3 28.7-64 64-64h224V32c0-17.7-14.3-32-32-32zm128 160c-17.7 0-32 14.3-32 32v32h96c35.3 0 64 28.7 64 64v128h192c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm240 64h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16h-32c-8.8 0-16-7.2-16-16v-32c0-8.8 7.2-16 16-16zM64 256c-17.7 0-32 14.3-32 32v13l155.1 114.9c1.4 1 3.1 1.6 4.9 1.6s3.5-.6 4.9-1.6L352 301v-13c0-17.7-14.3-32-32-32zm288 84.8L216 441.6c-6.9 5.1-15.3 7.9-24 7.9s-17-2.8-24-7.9L32 340.8V480c0 17.7 14.3 32 32 32h256c17.7 0 32-14.3 32-32z"/>'
		],

		'ftp' => [
			'box' => '0 0 122.88 109.36',
			'body' => '<path d="M14.69 16.44h3.56V8.63c0-1.09.88-1.97 1.97-1.97h3.5V1.97C23.72.88 24.6 0 25.69 0h31.92c1.09 0 1.97.88 1.97 1.97v4.69h43.05c1.09 0 1.97.88 1.97 1.97v7.82h3.59a1.97 1.97 0 0 1 1.93 2.39l-6.88 50.59a7.5 7.5 0 0 1-2.05 4.29 6 6 0 0 1-4.25 1.78H70.95v5.86h2.12a2.8 2.8 0 0 1 2.8 2.8v5.06h10.44a2.8 2.8 0 0 1 2.67 1.97h26.1a7.4 7.4 0 0 1 7.2 4.71 8.5 8.5 0 0 1 0 6.28 7.4 7.4 0 0 1-7.2 4.71H89.09a2.8 2.8 0 0 1-2.78 2.49H38.8a2.8 2.8 0 0 1-2.78-2.49H7.8a7.4 7.4 0 0 1-7.2-4.71 8.5 8.5 0 0 1 0-6.28 7.4 7.4 0 0 1 7.2-4.71h28.32a2.8 2.8 0 0 1 2.67-1.97h8.74v-5.06a2.8 2.8 0 0 1 2.8-2.8h1.69V75.5H24.38a6 6 0 0 1-4.3-1.79 7.2 7.2 0 0 1-2.01-4.33l-5.33-50.74a1.96 1.96 0 0 1 1.75-2.15q.1-.05.2-.05m16.69 17.99h16.29v4.58H38v3.72h8.26v4.3H38v8.71h-6.61V34.43zm18.7 0H70.1v5.27h-6.72v16.05h-6.59V39.7h-6.71zm23.33 0h10.95q3.58 0 5.35 1.7 1.78 1.7 1.78 4.84 0 3.23-1.94 5.05t-5.93 1.82h-3.6v7.91h-6.61zm6.62 9.09h1.61q1.9 0 2.68-.66.77-.66.77-1.69 0-1-.67-1.7-.66-.7-2.51-.7h-1.88zM56.38 81.34h10.21v-5.79H56.38zm32.73 13.54v8.27h25.97c1.97 0 3.22-1.04 3.76-2.37a4.7 4.7 0 0 0 0-3.52c-.54-1.33-1.79-2.37-3.76-2.37zM36 103.15v-8.27H7.8c-1.97 0-3.22 1.04-3.76 2.37a4.7 4.7 0 0 0 0 3.52c.54 1.33 1.79 2.37 3.76 2.37zM20.23 20.38h-3.35l5.1 48.57c.08.78.39 1.47.87 1.95q.6.62 1.53.64h72.54c.59 0 1.1-.24 1.48-.62.49-.49.82-1.22.93-2.03l6.6-48.51zm1.96-9.78v5.83l78.46-.83v-5H57.61a1.97 1.97 0 0 1-1.97-1.97V3.94H27.66v4.69c0 1.09-.88 1.97-1.97 1.97z"/>'
		],

		'key' => [
		'box' => '0 0 512 512',
		'body' => '<path d="M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391c-4.5 4.5-7 10.6-7 17v80c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24v-40h40c13.3 0 24-10.7 24-24v-40h40c6.4 0 12.5-2.5 17-7l33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zm40-256a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"/>'
		],
		
		'memory' => [
			'box' => '0 0 512 375.4',
			'body' => '<path fill-rule="nonzero" d="M25.1 40h34.3V0h25.8v40h47.7V0h25.8v40h47.6V0h25.9v40h47.6V0h25.9v40h47.6V0h25.8v40h47.7V0h25.8v40H487a25 25 0 0 1 25 25v247.7a25 25 0 0 1-25.1 25.1h-34.3v37.5h-25.8v-37.5h-47.6v37.5h-25.9v-37.5h-47.6v37.5h-25.9v-37.5h-47.6v37.5h-25.9v-37.5h-47.6v37.5h-25.8v-37.5H85.2v37.5H59.4v-37.5H25a25 25 0 0 1-25-25V65.1A25 25 0 0 1 25.1 40M180 240h-36l-13.4-30.4H122v30.5H90.8V137.8h51.6q35.1 0 35.1 35.8 0 24.6-15.2 32.4zm-58-77.5V186h9q6 0 8.7-1.2 2.7-1.3 2.7-5.7v-9.7q0-4.5-2.8-5.7-2.6-1.2-8.5-1.2zm98.7 77.6h-34.5l26.5-102.3h50.5l26.5 102.3h-34.5l-3.8-16.2h-27zm13.3-70.9-3.7 28.7h15l-3.4-28.7zm96.9 70.9h-34.2l6.2-102.3h42.7l12.8 52h1.1l12.8-52h42.6l6.3 102.3H387l-2-49.6h-1l-12.4 49.6h-25l-12.7-49.6h-1zM486.2 65.8H25.8V312h460.4z"/>'
		],
		
		'parent_folder' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M28 8H16l-3.414-3.414A2 2 0 0 0 11.172 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-9.17l2.59 2.58L22 18l-5-5-5 5 1.41 1.41L16 16.83V26H4V6h7.172l4 4H28v16h-6v2h6a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2z"/><path d="M0 0h32v32H0z" />'
		],

		'prompt' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M9.4 118.6 146.7 256 9.4 393.4a32 32 0 0 0 45.3 45.3l160-160a32 32 0 0 0 0-45.2l-160-160a32 32 0 0 0-45.3 0 32 32 0 0 0 0 45.1M288 448h192a32 32 0 1 0 0-64H288a32 32 0 1 0 0 64"/>'
		],
		
		'rocket' => [
			'box' => '0 0 512 512',
			'body' => '<path d="m127 247.8 50.1-76.9s-74.7-29.7-109.5-3S0 268.1 0 268.1l37.1 21.5s47-91 90-41.9M264 385l77-50s29.7 74.7 3 109.5S243.9 512 243.9 512l-21.5-37.1s91-47 41.9-90m-57.4-22-13.2-13.2c-24 62.4-80.4 49.2-80.4 49.2s-13.2-56.4 49.2-80.4l-13.2-13.2c-34.8-6-79.2 36-86.4 76.8s-8.4 75.6-8.4 75.6 34.8-1.2 75.6-8.4 82.8-51.6 76.8-86.4M505.2 6.8C450.8-18.7 313 29 236.2 130.7a1621 1621 0 0 0-89.6 129.6l46.4 46.4 12.3 12.3 46.4 46.4s52.2-31.2 129.7-89.6C483 199 530.7 61.2 505.2 6.8M274.6 237.4A32.8 32.8 0 1 1 321 191a32.8 32.8 0 0 1-46.4 46.4m77-77a42.4 42.4 0 1 1 60-60 42.4 42.4 0 0 1-60 60"/>'
		],

		'scroll' => [
			'box' => '0 0 576 512',
			'body' => '<path d="M0 80v48c0 17.7 14.3 32 32 32h64V80c0-26.5-21.5-48-48-48S0 53.5 0 80zm112-48c10 13.4 16 30 16 48v304c0 35.3 28.7 64 64 64s64-28.7 64-64v-5.3c0-32.4 26.3-58.7 58.7-58.7H480V128c0-53-43-96-96-96zm352 448c61.9 0 112-50.1 112-112 0-8.8-7.2-16-16-16H314.7c-14.7 0-26.7 11.9-26.7 26.7v5.3c0 53-43 96-96 96h176z"/>'
		],

		'server' => [
			'box' => '0 0 512 448',
			'body' => '
				<path d="M64 0C28.7 0 0 28.7 0 64v64c0 35.3 28.7 64 64 64h384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm48 24a24 24 0 1 1 48 0 24 24 0 1 1-48 0zM64 256c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64h384c35.3 0 64-28.7 64-64v-64c0-35.3-28.7-64-64-64zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1-48 0z" />'
		],
		
		'health' => [
			'box' => '0 0 448 512',
			'body' => '<path d="M64 32C28.7 32 0 60.7 0 96v320c0 35.3 28.7 64 64 64h320c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64zm272 120v208c0 13.3-10.7 24-24 24s-24-10.7-24-24v-80H160v80c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-13.3 10.7-24 24-24s24 10.7 24 24v80h128v-80c0-13.3 10.7-24 24-24s24 10.7 24 24z"/>'
		],

		'wrench' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M352 320c88.4 0 160-71.6 160-160 0-15.3-2.2-30.1-6.2-44.2-3.1-10.8-16.4-13.2-24.3-5.3l-76.8 76.8c-3 3-7.1 4.7-11.3 4.7H336c-8.8 0-16-7.2-16-16v-57.4c0-4.2 1.7-8.3 4.7-11.3l76.8-76.8c7.9-7.9 5.4-21.2-5.3-24.3C382.1 2.2 367.3 0 352 0c-88.4 0-160 71.6-160 160 0 19.1 3.4 37.5 9.5 54.5L19.9 396.1C7.2 408.8 0 426.1 0 444.1 0 481.6 30.4 512 67.9 512c18 0 35.3-7.2 48-19.9l181.6-181.6c17 6.2 35.4 9.5 54.5 9.5zM80 408a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"/>'
		],
		
		'301' => [
		'box' => '0 0 122.88 98.31',
		'body' => '<path d="M8.32 0h106.24a8.34 8.34 0 0 1 8.32 8.32V90a8.35 8.35 0 0 1-8.32 8.32H8.32A8.35 8.35 0 0 1 0 89.99V8.32A8.34 8.34 0 0 1 8.32 0m27.1 51.11-7.2-1.28a9 9 0 0 1 3.45-5.27q2.55-1.83 7.21-1.83 5.35 0 7.75 2a6.3 6.3 0 0 1 2.39 5.03q0 1.77-.97 3.21a8 8 0 0 1-2.92 2.52q1.6.4 2.42.92a6 6 0 0 1 2.88 5.49q0 2.4-1.25 4.59a8.5 8.5 0 0 1-3.6 3.38q-2.35 1.19-6.19 1.19-3.73 0-5.89-.88a9 9 0 0 1-3.55-2.57 12 12 0 0 1-2.14-4.26l7.62-1.01q.45 2.31 1.39 3.2t2.4.89q1.52 0 2.55-1.12a4.3 4.3 0 0 0 1.01-2.99q0-1.9-.98-2.95a3.5 3.5 0 0 0-2.65-1.05q-.9 0-2.46.45l.4-5.44q.62.1.98.1 1.48 0 2.46-.95a3 3 0 0 0 .99-2.25q0-1.26-.74-1.99-.75-.75-2.04-.75-1.33 0-2.18.81-.85.78-1.14 2.81m17.5 5.66q0-7.81 2.81-10.93t8.57-3.12q2.76 0 4.54.68a8 8 0 0 1 2.9 1.77 9 9 0 0 1 1.77 2.3q.65 1.2 1.04 2.81.77 3.06.77 6.39 0 7.46-2.53 10.91t-8.69 3.46q-3.45 0-5.59-1.1a9 9 0 0 1-3.5-3.23 12 12 0 0 1-1.54-4.13 29 29 0 0 1-.55-5.81m7.54.01q0 5.22.93 7.15.92 1.91 2.69 1.91 1.15 0 2.01-.81t1.25-2.57q.4-1.76.4-5.47 0-5.45-.93-7.34t-2.78-1.88q-1.89 0-2.73 1.91-.84 1.93-.84 7.1m34.62-14.06v27.87h-7.69V52.36q-1.86 1.41-3.62 2.28a29 29 0 0 1-4.38 1.67v-6.2a19 19 0 0 0 6.04-3.02 12 12 0 0 0 3.37-4.36zm22.89-19.43H5.29V90.8a2.3 2.3 0 0 0 2.3 2.3h108.04a2.3 2.3 0 0 0 2.3-2.3V23.29zM106.64 9.35a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22m-27.84 0a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22m13.92 0a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		'404' => [
		'box' => '0 0 122.88 98.31',
		'body' => '<path d="M8.32 0h106.24a8.35 8.35 0 0 1 8.32 8.32V90a8.35 8.35 0 0 1-8.32 8.32H8.32A8.35 8.35 0 0 1 0 90V8.32A8.34 8.34 0 0 1 8.32 0m29.14 65.4H23.01v-6.53l14.45-17.18h6.9v17.56h3.59v6.15h-3.59v5.35h-6.9zm0-6.15v-9.02l-7.63 9.02zm12.31-2.91q0-8.15 2.93-11.39t8.93-3.25q2.89 0 4.74.71a9 9 0 0 1 3.02 1.85q1.17 1.14 1.84 2.39t1.08 2.93q.8 3.2.8 6.67 0 7.77-2.63 11.37t-9.06 3.61q-3.6 0-5.83-1.15a9.6 9.6 0 0 1-3.65-3.37 13 13 0 0 1-1.61-4.31 31 31 0 0 1-.56-6.06m7.86.01q0 5.45.96 7.45t2.8 2q1.2 0 2.1-.84a5.3 5.3 0 0 0 1.3-2.68q.42-1.84.42-5.71 0-5.69-.96-7.65-.97-1.95-2.89-1.96-1.97 0-2.85 2-.88 1.98-.88 7.39m31.74 9.05H74.92v-6.53l14.45-17.18h6.9v17.56h3.59v6.15h-3.59v5.35h-6.9zm0-6.15v-9.02l-7.63 9.02zm28.6-35.96H5.29V90.8a2.3 2.3 0 0 0 2.3 2.3h108.04a2.3 2.3 0 0 0 2.3-2.3V23.29zM106.64 9.35a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22m-27.84 0a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22m13.92 0a4.11 4.11 0 1 1 0 8.22 4.11 4.11 0 0 1 0-8.22" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		// GROUP ICONS
		
		'license' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M352.9 232.8q2.6 1.7 5.5 4.3l.1.1c2.4 2 5.1 4.4 8.1 6.1 2.5 1.4 6.1 1.5 10 1.7 17.3.6 24.2 8.3 25.3 25v.7q.2 3.5 1.4 7.2 1.3 3.8 4.9 8.7a44 44 0 0 1 8.5 16.3c2.2 9.8-2.4 16.3-9.4 22.2-5 4.4-5.3 6-5.3 13-.1 4-.2 8-2.8 13.3v.2a24 24 0 0 1-24.5 13.9c-2.3-.2-4.4-.4-6 .3h-.2c-3.4 1.5-6.5 4-9.4 6.4-13.7 11-23.2 9.5-35.2-.1a41 41 0 0 0-9.5-6.3c-1.6-.7-3.7-.5-6-.4a23 23 0 0 1-18.2-5.7 27 27 0 0 1-6.4-8.3 27 27 0 0 1-2.7-13.4c-.1-3-.1-5.8-1.4-8.9-.6-1.2-2.3-2.6-4-4.2-7-6-11.7-12.2-9.5-22.1q1.6-7.1 8.6-16.3 3.7-4.9 4.9-8.7t1.3-7.3v-.5c1.1-16.9 8-24.5 25.4-25 3.8-.2 7.5-.4 10-1.8q4.5-2.7 8-6.1 3-2.6 5.7-4.4c7.5-5 15.3-4.5 22.8 0M23.9 57h464.3c6.5 0 12.5 2.7 16.8 7a24 24 0 0 1 7 16.9v297a24 24 0 0 1-23.9 23.8h-26.8c-6.5-13.3-13.7-26.4-20.5-39.5L486 317V129.3L439.6 83H72.4L26 129.3v199.8l46.4 46.5h162.8l-13.5 26H24c-6.6 0-12.6-2.7-17-7a24 24 0 0 1-7-16.9v-297A24 24 0 0 1 23.9 57m94.8 120.8-1.1 14.5H80.3l1-18.4-1-44.2h19.8L99 171.8l.2 4.5h18.5zM88.6 327c17.6-23.1 32.6-12.6 53.6 2l3.2 2.3c3 2 6.1 1.7 9.3.1a53 53 0 0 0 10.3-7.7q4.5-4.4 9.4-7.5.9-.5 1.6.4l4.8 7.5q.5 1-.4 1.6-3.8 2.6-8 6.4v.1a58 58 0 0 1-15.1 10.8 18 18 0 0 1-18.4-2.4l-3.2-2.2a74 74 0 0 0-21.2-12c-6-1.4-11.4.3-17 7.5q-.6.8-1.6.2l-7-5.4q-1-.8-.3-1.7m-4.3-81.4q-1.6 0-2.8-1.8-1.1-1.6-1.2-4.2t1.2-4.3q1.1-1.6 2.8-1.7h83.1q1.7 0 2.8 1.7a6 6 0 0 1 1.2 4.3q0 2.6-1.2 4.2t-2.8 1.8zm0 36q-1.6 0-2.8-1.8-1.1-1.7-1.2-4.2 0-2.6 1.2-4.3t2.8-1.7H199q1.5 0 2.8 1.7 1 1.7 1.1 4.3 0 2.6-1.1 4.2t-2.8 1.8zm59.6-109.9.7 20.4h-19.4l1-18.4-1-44.2h19.7zm41.8-43.3q8.4 0 15.7 2.6l-3.3 15.4-1.3.8q-2.4-1.4-5.8-2.2a25 25 0 0 0-6-.8q-6 0-8.6 3.4c-2.6 3.4-2.6 6.1-2.6 11.5q0 9.3 3 13.7c3 4.4 5.1 4.3 9.4 4.3a38 38 0 0 0 12-2l1.4.9-1.5 15.3a45 45 0 0 1-13.4 1.8q-15.6 0-23.5-8.1t-7.9-23.7 8.5-24.3q8.4-8.6 24-8.6m68 49 1 1.4-1.1 13.3h-44.1l1-18.4-1-44.2h44.8l1.1 1.3-1.3 13.3-25.3-.6-.2 9.7 19.6-.3 1.1 1.3-1.2 14.2-19.9-.3v3.6l.1 6.3zm66.9-5.7.8 20.4h-21.1l-17.6-33.5h-1.2l-.1 10.8.8 22.7h-17.6l1-18.4-1-44.2h21l17.7 33.4h1.1l-.6-32.7 17.8-1.1zm37-43.4q9.2 0 18.2 3.4l-3.1 15.8-2.7 1.1a44 44 0 0 0-8-4q-4-1.4-6.4-1.4-2.2 0-3.6.9c-1.4.9-1.3 1.3-1.3 2.3q0 1.8 2 3.2 2 1.3 6.6 3.4 5.4 2.4 9 4.5 3.4 2 6 5.7 2.6 3.6 2.6 9 0 5.9-3.2 10.6a22 22 0 0 1-9.2 7.6q-6 2.8-14 2.8-9.7 0-20.7-3.7l2.8-16.8 2-1.1q4.5 3.3 9.5 5.3t8.5 2q2.6 0 3.9-1 1.2-.8 1.2-2.2 0-2-2-3.4-2.2-1.4-6.8-3.5-5.3-2.3-8.8-4.4a20 20 0 0 1-6-5.7 15 15 0 0 1-2.4-9q0-6 3.3-10.9 3.2-4.8 9.2-7.7c6-2.9 8.4-2.8 13.4-2.8m72.2 49.1 1 1.4-1 13.3h-44.2l1-18.4-1-44.2h45l1 1.3-1.3 13.3-25.3-.6-.2 9.7 19.6-.3 1 1.3-1 14.2-20-.3-.1 3.6.2 6.3zm-12 259.8-18.9-3.4-9.4 17-.3.3c-4 4.8-7.6 4.7-10.7 2.2a31 31 0 0 1-7-12.6l-.6-1.4-20-37.7a2.3 2.3 0 0 1 1-3.2l.3-.1q3-1.1 6.9-4 4-3 8.2-7 .8-.6 1.8-.5c5.4 0 10.7-.3 15.4-2q7-2 12.5-8.9c.8-1 2.3-1.2 3.3-.4q.4.3.6.8l23.1 44.6 2 4.3.2.4q1.4 5 0 8.4-1.8 3.7-7.9 3.4zM284 433.9l-18.9 3.4h-.6q-6 .3-7.8-3.3-1.6-3.3 0-8.4l.1-.4 2-4.3 23.1-44.6.6-.8q1.9-1.2 3.4.4c3.5 4.6 7.8 7.3 12.5 9q7.2 2.3 15.3 1.8 1 0 1.8.7 4.3 3.9 8.2 6.9a26 26 0 0 0 7 4h.2c1.2.7 1.7 2.2 1 3.3l-20 37.7-.5 1.4a31 31 0 0 1-7 12.5c-3.2 2.5-6.8 2.7-10.8-2.2l-.2-.3zm86.6-158.7a41 41 0 0 0-70.3 29.1 41 41 0 0 0 41.2 41.2 41 41 0 0 0 29-70.3" fill-rule="nonzero"/>'
		],
		
		'wpa' => [
		'box' => '0 0 20 20',
		'body' => '<path d="M18.782 9.99h-.301c0 6.044-6.54 7.264-6.54 7.264q-.646.111-1.313.141a9.92 9.92 0 0 1-7.177-2.63A9.92 9.92 0 0 1 .234 7.83a10 10 0 0 0-.225 2.576 9.92 9.92 0 0 0 3.217 6.935 9.93 9.93 0 0 0 7.179 2.63 9.92 9.92 0 0 0 6.935-3.216c1.213-1.319 2.263-2.9 2.638-4.604-.234-.758-.789-1.482-1.195-2.16" fill="#ee5b4c"/><path d="M6.412 6.697a4.83 4.83 0 0 1 3.376-1.565 9.92 9.92 0 0 1 7.179 2.63 10 10 0 0 1 1.815 2.228h.638a9.9 9.9 0 0 0-2.891-4.776 9.92 9.92 0 0 0-7.178-2.63q-.666.028-1.312.142-.142.14-.278.287A9.92 9.92 0 0 0 5.127 9.99c0-1.224.45-2.387 1.286-3.293" fill="#6d60aa"/><path d="M19.996 12.181s-.555-2.192-.83-3.239l-.995-.012c.622 1.023 1.825 3.251 1.825 3.251" fill="#6d60aa"/><path d="M6.697 13.568a4.83 4.83 0 0 1-1.565-3.376l-.007-.202a9.92 9.92 0 0 1 2.636-6.977 9.9 9.9 0 0 1 4.39-2.778h-.004a9.92 9.92 0 0 0-6.933 3.213 9.92 9.92 0 0 0-2.63 7.18 10 10 0 0 0 .142 1.313q.141.141.286.276a9.92 9.92 0 0 0 7.18 2.63 4.83 4.83 0 0 1-3.495-1.28" fill="#2170b6"/><path d="M18.48 9.99h-3.628a4.83 4.83 0 0 1-1.286 3.292 4.83 4.83 0 0 1-3.375 1.566 9.92 9.92 0 0 1-7.179-2.63A10 10 0 0 1 1.198 9.99a10 10 0 0 1-.964-2.16 9.92 9.92 0 0 0 3.217 6.936 9.92 9.92 0 0 0 7.179 2.629q.665-.03 1.31-.141s6.54-1.22 6.542-7.264" fill="#c51f31"/><path d="M9.575.009A9.92 9.92 0 0 0 2.64 3.226 9.9 9.9 0 0 0 .234 7.83a10 10 0 0 0 .964 2.159 10 10 0 0 0 1.528 1.952 10 10 0 0 1-.147-1.952 9.92 9.92 0 0 1 2.635-6.54A9.92 9.92 0 0 1 12.148.232 10 10 0 0 0 9.575.009" fill="#78a6d8"/><path d="M18.782 9.99a10 10 0 0 0-1.527-1.951 10 10 0 0 1 .146 1.95v4.877c0 2.976 2.577 4.876 2.577 4.876v-7.593z" fill="#e73d92"/><path d="M19.97 9.575a9.92 9.92 0 0 0-3.216-6.935A9.9 9.9 0 0 0 12.15.234a9.9 9.9 0 0 0-4.113 2.49q.648-.111 1.314-.14a9.92 9.92 0 0 1 7.179 2.63 9.9 9.9 0 0 1 2.89 4.776h.558q0-.206-.008-.415" fill="#906eb0"/><path d="m19.97 9.86-.588.006c.205.826.618 2.555.618 2.555Z" fill="#906eb0"/><path d="M17.401 14.866V9.99q.007-.318-.006-.64a10 10 0 0 0-.141-1.311 9.92 9.92 0 0 0-7.467-2.907 4.83 4.83 0 0 1 3.495 1.28 4.83 4.83 0 0 1 1.572 3.578v4.626a5.124 5.124 0 0 0 5.124 5.126s-2.577-1.9-2.577-4.876" fill="#98226e"/>'
		],
		
		'wpap' => [
		'box' => '0 0 24 24',
		'body' => '<path d="M3 23a1 1 0 0 1-1-1V2a1 1 0 0 1 2 0v1h4a1 1 0 0 1 0 2H4v6h8a1 1 0 0 1 0 2H4v6h2a1 1 0 0 1 0 2H4v1a1 1 0 0 1-1 1M21 3h-8V2a1 1 0 0 0-2 0v4a1 1 0 0 0 2 0V5h8a1 1 0 0 0 0-2m0 8h-4v-1a1 1 0 0 0-2 0v4a1 1 0 0 0 2 0v-1h4a1 1 0 0 0 0-2m0 8H11v-1a1 1 0 0 0-2 0v4a1 1 0 0 0 2 0v-1h10a1 1 0 0 0 0-2"/>'
		],
		
		'wpas' => [
		'box' => '0 0 111.811 122.88',
		'body' => '<path fill-rule="evenodd" clip-rule="evenodd" d="M55.713 0c20.848 13.215 39.682 19.467 55.846 17.989 2.823 57.098-18.263 90.818-55.63 104.891C19.844 109.708-1.5 77.439.083 17.123c18.975.993 37.591-3.109 55.63-17.123zm.45 19.543c14.217 9.011 27.061 13.274 38.083 12.268 1.925 38.936-12.454 61.93-37.935 71.526-.161-.059-.319-.12-.479-.18V19.796l.331-.253zm-.428-12.488c18.454 11.697 35.126 17.232 49.434 15.923 2.498 50.541-16.166 80.39-49.241 92.846C23.986 104.165 5.091 75.603 6.493 22.211c16.797.88 33.275-2.751 49.242-15.156z"/>'
		],
		
		'wpau' => [
		'box' => '0 0 118.91 122.88',
		'body' => '<path fill-rule="evenodd" d="m6.41 23.43 49.53 20.15c1.57.64 4.17 1.04 5.74.4l52.42-21.41c1.57-.64-.02-3.49-1.62-4.05L59.62 0c-.4-.14-10.33 3.48-11.72 3.97L4.79 19.38c-1.67.59-.53 3.17 1.62 4.05m110.46 70.91L65.14 122.4c-1.49.81-3.56.69-3.56-1.01l-.01-66.03c0-1.7.14-3.36 1.7-4.03l51.92-22.12c1.56-.66 3.73-.07 3.72 1.62l-.34 59.48c-.01 1.69-.21 3.22-1.7 4.03m-11.88-23.25c3.52 1.5 4.55 6.77 2.28 11.78-2.26 5-6.96 7.84-10.48 6.34s-4.55-6.77-2.28-11.78 6.96-7.84 10.48-6.34M86.22 57.28c3.65 1.55 4.7 7.01 2.36 12.19s-7.2 8.12-10.85 6.57-4.7-7.01-2.36-12.19c2.34-5.19 7.2-8.13 10.85-6.57M1.81 93.89l51.26 27.75c1.49.81 3.56.69 3.56-1.01l.01-65.42c0-1.7-.14-3.36-1.7-4.03L3.72 29.22C2.16 28.55 0 29.15 0 30.85l.11 59.02c0 1.69.21 3.21 1.7 4.02m5.1-18.15c3.21-2.04 7.99.29 10.66 5.2s2.24 10.56-.97 12.6-7.99-.29-10.66-5.2-2.24-10.56.97-12.6m15.15-11.37c3.4-2.06 8.45.29 11.28 5.26s2.38 10.67-1.02 12.73-8.45-.29-11.28-5.26-2.38-10.66 1.02-12.73m16.06-12c3.42-2.07 8.51.29 11.36 5.26s2.39 10.68-1.03 12.74-8.51-.29-11.36-5.26-2.39-10.67 1.03-12.74m21.04-36.89c6.04 0 10.93 2.34 10.93 5.22s-4.89 5.22-10.93 5.22-10.93-2.34-10.93-5.22 4.9-5.22 10.93-5.22" clip-rule="evenodd"/>'
		],
		
		'wpav' => [
		'box' => '0 0 122.88 122.88',
		'body' => '<path d="M61.44 0a61.3 61.3 0 0 1 23.5 4.66l.11.05c7.47 3.11 14.2 7.66 19.83 13.3a61.4 61.4 0 0 1 13.34 19.95c3.01 7.24 4.66 15.18 4.66 23.49a61.3 61.3 0 0 1-4.66 23.5l-.05.11a61.5 61.5 0 0 1-13.3 19.83 61.4 61.4 0 0 1-19.95 13.34c-7.24 3.01-15.18 4.66-23.49 4.66s-16.25-1.66-23.5-4.66l-.11-.05a61.5 61.5 0 0 1-19.83-13.29l.01-.02A61.7 61.7 0 0 1 4.66 84.94C1.66 77.69 0 69.76 0 61.44s1.66-16.25 4.66-23.5l.05-.11A61.5 61.5 0 0 1 18 18h.01A61.6 61.6 0 0 1 37.95 4.66C45.19 1.66 53.12 0 61.44 0M16.99 94.47l.24-.14c5.9-3.29 21.26-4.38 27.64-8.83.47-.7.97-1.72 1.46-2.83.73-1.67 1.4-3.5 1.82-4.74-1.78-2.1-3.31-4.47-4.77-6.8l-4.83-7.69c-1.76-2.64-2.68-5.04-2.74-7.02q-.045-1.395.48-2.52c.36-.78.91-1.43 1.66-1.93.35-.24.74-.44 1.17-.59-.32-4.17-.43-9.42-.23-13.82.1-1.04.31-2.09.59-3.13 1.24-4.41 4.33-7.96 8.16-10.4 2.11-1.35 4.43-2.36 6.84-3.04 1.54-.44-1.31-5.34.28-5.51 7.67-.79 20.08 6.22 25.44 12.01 2.68 2.9 4.37 6.75 4.73 11.84l-.3 12.54c1.34.41 2.2 1.26 2.54 2.63.39 1.53-.03 3.67-1.33 6.6-.02.05-.05.11-.08.16l-5.51 9.07c-2.02 3.33-4.08 6.68-6.75 9.31.25.36.5.71.74 1.06 1.09 1.6 2.19 3.2 3.6 4.63q.075.075.12.15c6.34 4.48 21.77 5.57 27.69 8.87l.24.14c6.87-9.22 10.93-20.65 10.93-33.03 0-15.29-6.2-29.14-16.22-39.15-10-10.03-23.85-16.23-39.14-16.23s-29.14 6.2-39.15 16.22C12.27 32.3 6.07 46.15 6.07 61.44c0 12.38 4.06 23.81 10.92 33.03"/>'
		],
		
		'wpb' => [
		'box' => '0 0 600 600',
		'body' => '<path fill-rule="evenodd" d="M537.48 336.62a158 158 0 0 1 39.5 104.74c0 87.6-71 158.64-158.65 158.64-60.79 0-113.62-34.23-140.23-84.42h-72.3v33.88H97.88v-33.88H23.07v-39.36h74.8V442h34.28v-77.5H58.37a35.2 35.2 0 0 1-24.95-10.35 35 35 0 0 1-10.4-24.95V205.03a35 35 0 0 1 8.35-22.75 35 35 0 0 1-8.35-22.8V35.34A35.2 35.2 0 0 1 33.37 10.4a35 35 0 0 1 25-10.4H503a35.2 35.2 0 0 1 24.95 10.35 35.2 35.2 0 0 1 10.36 24.95v124.17c0 8.65-3.18 16.6-8.35 22.76a35 35 0 0 1 8.35 22.75v124.17q-.02 3.81-.83 7.47M490.5 376.9v52.5h-58.69l4.4-4.4 15.28-15.28a51.3 51.3 0 0 0-32.52-11.62 51.07 51.07 0 0 0-51.27 51.27v.04c0 50.59 79.69 67.1 96.14 15.63l.59-1.76h35.6l-.64 3.08v.1a82 82 0 0 1-4.74 15.04c-22.17 52.34-97.65 62.35-136.81 23.19a81.8 81.8 0 0 1-24.03-58.01v-.05c0-58.3 60.26-99.12 114.9-75.3A81 81 0 0 1 473.36 388l12.85-12.84 4.39-4.4v6.15zm-226.9 99.32a158 158 0 0 1-3.86-34.86c0-27.88 7.23-54.1 19.83-76.86H171.46v77.54h34.28v34.23h57.86zm-111.77-4.98c13.53 0 24.51 10.99 24.51 24.51s-10.98 24.51-24.5 24.51-24.52-10.98-24.52-24.5a24.5 24.5 0 0 1 24.51-24.52M92.21 63.62h26.13v67.63H92.2zM451.2 246.4a20.71 20.71 0 0 1 4.88 40.82 160 160 0 0 1 57.32 26.95V205.03a10.3 10.3 0 0 0-3.07-7.32 10.5 10.5 0 0 0-5.47-2.88q-.97.05-1.86.04H58.37q-.96.01-1.85-.05a10.5 10.5 0 0 0-5.47 2.89 10 10 0 0 0-3.12 7.32V329.2a10.3 10.3 0 0 0 3.07 7.32c1.9 1.9 4.5 3.08 7.32 3.08h237.16a161 161 0 0 1 52.25-40.77 160 160 0 0 1 70.26-16.16 162 162 0 0 1 21.34 1.41 20.71 20.71 0 0 1 11.87-37.7zm-78.86 0a20.71 20.71 0 0 1 0 41.4 20.71 20.71 0 0 1 0-41.4m-135.7-13.09h26.13v67.63h-26.12zm-72.21 0h26.12v67.63h-26.12zm-72.22 0h26.13v67.63H92.2zM451.2 76.7a20.71 20.71 0 0 1 0 41.42 20.71 20.71 0 0 1 0-41.41m-78.86 0a20.71 20.71 0 0 1 0 41.4 20.71 20.71 0 0 1 0-41.4m-135.7-13.09h26.13v67.63h-26.12zm-72.21 0h26.12v67.63h-26.12zM56.47 169.72q.96-.05 1.85-.04h444.63q.97-.01 1.86.05a10.5 10.5 0 0 0 5.47-2.88c1.9-1.9 3.07-4.5 3.07-7.33V35.35a10.5 10.5 0 0 0-3.07-7.37c-1.9-1.9-4.5-3.08-7.33-3.08H58.37A10.5 10.5 0 0 0 51 27.98c-1.9 1.9-3.07 4.5-3.07 7.37v124.17a10.3 10.3 0 0 0 3.07 7.33 10.5 10.5 0 0 0 5.47 2.88zm444.87 166.46a137 137 0 0 0-30.95-18.16 135 135 0 0 0-52.35-10.45 136 136 0 0 0-33.54 4.2c-57.57 15.04-100.05 67.38-100.05 129.64 0 73.97 59.96 133.98 133.98 133.98 74.03 0 133.99-59.96 133.99-133.98a134.2 134.2 0 0 0-51.08-105.23"/>'
		],

		'wpbn' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M145.02 325.664 132.422 245c123.633-30.566 205.713-33.106 335.254 0l-13.282 80.664c-125.244-33.545-198.583-29.297-309.374 0m316.357 7.031 11.035-59.033c44.726 9.863 85.45 23.926 127.588 40.918l-85.987 8.984c14.747 16.602 28.223 34.668 40.43 54.053-47.607-16.895-90.039-29.443-125.537-36.084l2.442-15.87zm-322.754 1.27-11.035-59.033C82.862 284.795 42.09 298.808 0 315.849l85.987 8.985c-14.747 16.601-28.223 34.668-40.43 54.053 47.607-16.895 90.039-29.444 125.537-36.084l-2.442-15.87z"/>'
		],
		
		'wpbs' => [
		'box' => '0 0 117 122.9',
		'body' => '<path d="M82.4 47.3q19.4 12.3 34.4 11c1.7 35.2-11.2 56-34.2 64.6-22.2-8.1-35.4-28-34.4-65 11.7.5 23.1-2 34.2-10.6m-38.3 48q-10.5-9-17-18H13.4a44 44 0 0 0 19 14.9 43 43 0 0 0 11.9 3.1M10.5 73h14q-6-10.2-6.3-20.7H4.4A47 47 0 0 0 8 67.8q1.2 2.7 2.6 5.1m-6-25h13.8Q19 37.5 25 27.2H10.5l-2.6 5v.2a43 43 0 0 0-3.5 15.5m8.8-25.1H28q6.3-9 16.6-18a43 43 0 0 0-12.2 3.1 49 49 0 0 0-14.6 9.8q-2.4 2.4-4.4 5.1m42.3-18q10.4 9 16.5 18h14.7a44 44 0 0 0-19-15 44 44 0 0 0-12.2-3m34 22.4H75q3.3 5.7 5 11.4L76.2 41a50 50 0 0 0-6.4-14H52.2v20.7h9.4a66 66 0 0 1-23 2.7l-.1 1.7h-16q.6 10.4 7 20.7h10q.1 2.3.6 4.4h-7.5q4.1 5.3 9.7 10.5 1.7 6.6 4.2 12.1a50 50 0 0 1-15.8-3.7h-.2a53 53 0 0 1-15.9-10.8A49 49 0 0 1 4 69.5 48 48 0 0 1 0 50a51 51 0 0 1 8.6-28 49 49 0 0 1 22-18Q35 1.8 40 1a50.4 50.4 0 0 1 56.2 29.5 48 48 0 0 1 3.8 16l-4.6-2a45 45 0 0 0-3.2-12.2q-1.2-2.7-2.6-5.1M52.2 7.6v15.2h14.6Q61 15.3 52.2 7.6m-4.4 40.3V27.1H30.4q-6.8 10.5-7.6 20.6zm0-25.1V7.6a105 105 0 0 0-14.5 15.2zm35 36.5a39 39 0 0 0 23.3 7.6c1.2 23.9-7.6 38-23.3 44l-.3-.2V59.4zm-.3-7.7a51 51 0 0 0 30.4 9.8c1.5 31.1-10 49.5-30.3 57.1-19.7-7.1-31.3-24.7-30.4-57.6a43 43 0 0 0 30.3-9.3" fill-rule="evenodd" clip-rule="evenodd"/>'
		],
		
		'wpbu' => [
			'box' => '0 0 225 225',
			'body' => '<path d="M103.5 23.5q18.3 2 29.5 17a55 55 0 0 1 11.5 35 5 5 0 0 0-3 .5 65 65 0 0 1 25 8 104 104 0 0 1 16.5 19.5q-3 14.6-18.5 15.5a28 28 0 0 1-28.5-9.5 11 11 0 0 0 3 7 29 29 0 0 0 25.5 7q1.7 15.6-6.5 29a195 195 0 0 0-14 19 21 21 0 0 0 9 22q1.5 2.3 1.5 5a145 145 0 0 1-17-.5 569 569 0 0 0-11.5-19.5 9 9 0 0 0-4-3 42 42 0 0 0-11.5 7.5 43 43 0 0 1-13 0 33 33 0 0 0 7.5-33.5q-12.8-25-38.5-13.5a19 19 0 0 0-6.5 8.5q14.7-12.6 31.5-2.5a26 26 0 0 1 8.5 27.5A33 33 0 0 1 87.5 187l32 1q6.7 3.1 8 10.5-28.5.3-57-.5-3.2-3-1-7-9 .8-18 0Q32 182.4 41 163.5a27 27 0 0 0 12 19Q31.7 136.7 74.5 109q22-11 46-5.5.5 4.5 3.5 8 1.2 2.3 3.5 1.5a14 14 0 0 1-2.5-5.5l-1-17a15 15 0 0 0-4.5-4.5q-15-6.5-28-16A58 58 0 0 1 73 39.5q-1.2-6 .5-11.5 15.3-3.3 29.5 3.5l1.5-.5q-3-3.5-1-7.5"/><path d="M79.5 29.5a57 57 0 0 1 53.5 42 47 47 0 0 1 2 20 248 248 0 0 0-18-38A41 41 0 0 0 80.5 35 26 26 0 0 0 85 50.5 74 74 0 0 0 98.5 66a299 299 0 0 0 25 13q5 4.4 6.5 10.5a35 35 0 0 0-7.5-6.5A78 78 0 0 1 81 51.5a32 32 0 0 1-5-20 20 20 0 0 0 3.5-2"/><path d="M148.5 89.5q10.7-4.5 14 7-3 1.7-6 .5a41 41 0 0 0-8-7.5"/><path d="M174.5 103.5q3.6-1.8 6 2a5 5 0 0 1-1.5 2 25 25 0 0 0-4.5-4"/><path d="M117.5 133.5a91 91 0 0 0 7.5 24 20 20 0 0 1-7.5-24"/>'
		],
		
		'wpc' => [
			'box' => '0 0 122.88 101.57',
			'body' => '<g><path d="M44.97,12.84h-17.2L0,49.37L27.77,85.9h17.2L17.2,49.37L44.97,12.84L44.97,12.84z M77.91,12.84h17.2l27.77,36.53 L95.11,85.9h-17.2l27.77-36.53L77.91,12.84L77.91,12.84z M70.17,0.04l5.96,1.39c0.94,0.22,1.52,1.16,1.31,2.1l-22.5,96.69 c-0.22,0.93-1.16,1.52-2.1,1.31l-5.95-1.39c-0.94-0.22-1.52-1.16-1.31-2.1l22.5-96.69C68.3,0.42,69.24-0.17,70.17,0.04L70.17,0.04 L70.17,0.04z"/></g>'
		],
		
		'wpca' => [
			'box' => '0 0 18 18',
			'body' => '<path d="M17.357 10.275v-.643a.643.642 0 1 0-1.286 0v.643h-.642v-.643a.643.642 0 1 0-1.285 0v.643H13.5v-.643a.643.642 0 1 0-1.286 0v.643h-.643v-.643a.643.642 0 1 0-1.285 0v.643h-.643v-.643a.643.642 0 1 0-1.286 0v.643h-.643v-.643a.643.642 0 1 0-1.285 0v.643h-.643v-.643a.643.642 0 1 0-1.286 0v.643h-.643v-.643a.643.642 0 1 0-1.286 0v.643H1.93v-.643a.643.642 0 1 0-1.286 0v.643a.643.642 0 0 0-.643.642v5.137a.643.642 0 0 0 .643.643v.642a.643.642 0 1 0 1.286 0v-.642h.642v.642a.643.642 0 1 0 1.285 0v-.642H4.5v.642a.643.642 0 1 0 1.286 0v-.642h.643v.642a.643.642 0 1 0 1.285 0v-.642h.643v.642a.643.642 0 1 0 1.286 0v-.642h.643v.642a.643.642 0 1 0 1.285 0v-.642h.643v.642a.643.642 0 1 0 1.286 0v-.642h.643v.642a.643.642 0 1 0 1.286 0v-.642h.642v.642a.643.642 0 1 0 1.286 0v-.642a.643.642 0 0 0 .643-.643v-5.138a.643.642 0 0 0-.643-.642ZM1.286 15.412V11.56h15.428v3.854ZM5.143 2.569v5.78a.643.642 0 1 0 1.286 0V3.211h3.59l1.552 1.55v3.587a.643.642 0 1 0 1.286 0V4.494a.643.642 0 0 0-.188-.453L10.74 2.114a.643.642 0 0 0-.454-.189h-4.5a.643.642 0 0 0-.643.643z"/><path d="M3.857 7.706a.643.642 0 0 0 .643-.643V1.285H9A.643.642 0 1 0 9 0H3.857a.643.642 0 0 0-.643.642v6.421a.643.642 0 0 0 .643.643m6.429-2.569H7.714a.643.642 0 1 0 0 1.284h2.572a.643.642 0 1 0 0-1.284m0 1.927H7.714a.643.642 0 1 0 0 1.284h2.572a.643.642 0 1 0 0-1.284"/>'
		],

		'wpce' => [
			'box' => '0 0 24 24',
			'body' => '<path d="M13.03 17H3.7l5.96-5.96L12 12.83l2.33-1.8 1.6 1.6a6 6 0 0 1 1-.4l-1.8-1.8L21 5.9v6.72a6 6 0 0 1 1 .64V5.5A1.5 1.5 0 0 0 20.5 4h-17A1.5 1.5 0 0 0 2 5.5v11A1.5 1.5 0 0 0 3.5 18h9.53a6 6 0 0 1 0-1M3 16.3V5.9l5.87 4.52zM20.5 5h.03L12 11.58 3.48 5.01 3.5 5zm-2 8a4.5 4.5 0 0 0-4.5 4.5l.05.5a4.5 4.5 0 0 0 4.45 4h.5v-1h-.5a3.5 3.5 0 0 1-3.45-3l-.05-.5a3.5 3.5 0 0 1 5.95-2.5H20v.51a2.5 2.5 0 0 0-1.5-.51 2.5 2.5 0 1 0 1.73 4.3 1.5 1.5 0 0 0 2.77-.8v-1a4.56 4.56 0 0 0-4.5-4.5m0 6a1.5 1.5 0 0 1-1.4-1 2 2 0 0 1-.1-.5 1.5 1.5 0 0 1 3 0 2 2 0 0 1-.1.5 1.5 1.5 0 0 1-1.4 1m3.5-.5a.5.5 0 0 1-1 0v-3.45a3.6 3.6 0 0 1 1 2.45z"/><path fill="none" d="M0 0h24v24H0z"/>'
		],
		
		'wpci' => [
			'box' => '0 0 158.75 158.75',
			'body' => '<path d="M141.97 11.34h-39.92a5.67 5.67 0 1 0 0 11.34h39.92a5.45 5.45 0 0 1 5.44 5.44v28.57H85.05a5.67 5.67 0 1 0 0 11.34h62.36v34.02H56.7V68.04a5.67 5.67 0 1 0-11.34 0v73.93a16.8 16.8 0 0 0 16.78 16.78h79.83a16.8 16.8 0 0 0 16.78-16.78V28.12a16.8 16.8 0 0 0-16.78-16.78m5.44 130.63a5.45 5.45 0 0 1-5.44 5.44H62.14a5.45 5.45 0 0 1-5.44-5.44v-28.58h90.71zm-85.04-79.6a6 6 0 0 0 2.53-.6l22.68-11.34a5.7 5.7 0 0 0 3.14-5.07V17l-.03-.21q-.02-.24-.07-.47a6 6 0 0 0-.42-1.56c-.04-.1-.03-.2-.08-.3q-.05-.08-.12-.15a6 6 0 0 0-1.22-1.55l-.3-.2q-.4-.37-.9-.63L64.9.6a5.7 5.7 0 0 0-5.07 0L37.15 11.94c-.33.16-.61.4-.9.62-.1.08-.2.12-.3.2a6 6 0 0 0-1.21 1.56l-.12.15c-.05.1-.04.2-.09.3a6 6 0 0 0-.42 1.56q-.05.23-.06.47l-.03.2v28.36a5.7 5.7 0 0 0 3.13 5.07l22.68 11.34a6 6 0 0 0 2.54.6m5.67-14.85V31.85l11.34-5.67v15.67zm-5.67-35.51 10 5-10 5-10-5zM45.36 26.18l11.34 5.67v15.67l-11.34-5.67zM22.68 5.67h-17a5.67 5.67 0 1 0 0 11.34h17a5.67 5.67 0 1 0 0-11.34m0 17h-17a5.67 5.67 0 1 0 0 11.35h17a5.67 5.67 0 1 0 0-11.34m0 17h-17a5.67 5.67 0 1 0 0 11.35h17a5.67 5.67 0 1 0 0-11.34zm79.37 11.35a5.67 5.67 0 0 0 5.67-5.67V34.02a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 0 0 5.67 5.67m22.68-5.67V34.02a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 1 0 11.34 0m17 0V34.02a5.67 5.67 0 1 0-11.33 0v11.34a5.67 5.67 0 1 0 11.34 0zm-17 45.35V79.37a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 1 0 11.34 0m-17 0V79.37a5.67 5.67 0 1 0-11.35 0v11.34a5.67 5.67 0 1 0 11.34 0m34.02 0V79.37a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 1 0 11.34 0m-39.69 51.03a5.67 5.67 0 0 0 5.67-5.67v-11.34a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 0 0 5.67 5.67m17.01 0a5.67 5.67 0 0 0 5.67-5.67v-11.34a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 0 0 5.67 5.67m17.01 0a5.67 5.67 0 0 0 5.67-5.67v-11.34a5.67 5.67 0 1 0-11.34 0v11.34a5.67 5.67 0 0 0 5.67 5.67"/>'
		],
		
		'wpco' => [
			'box' => '0 0 122.9 95.09',
			'body' => '<path d="M66.6 9.7a4 4 0 0 0-2.8-1.2q-1.5 0-2.8 1.2l-4.2 4.2-3.6-2-3.9-1.4V3.9q0-1.6-1.1-2.8A4 4 0 0 0 45.4 0h-8.2q-1.6 0-2.8 1.1-1 1.2-1.1 2.8v6l-4 1.2-3.7 1.7L21 8.2A4 4 0 0 0 18.2 7q-1.6 0-2.8 1.2l-5.7 5.7q-1.2 1.2-1.2 2.8t1.2 2.8l4.2 4.3-2 3.6-1.4 3.8H3.9q-1.5 0-2.8 1.2-1 1-1.1 2.7v8.2q0 1.5 1.1 2.8T4 47.3h6l1.2 4 1.7 3.7-4.6 4.6Q7 60.6 7 62.3q0 1.6 1.2 2.8l5.7 5.8a4 4 0 0 0 2.8 1.1q1.6 0 2.8-1l4.3-4.4 3.6 2 3.8 1.5v6.5q0 1.5 1.2 2.8 1 1 2.7 1.1h8.2q1.5 0 2.8-1.1t1.2-2.8v-6l4-1.2 3.7-1.7 4.6 4.6q1 1.2 2.8 1.2 1.6 0 2.7-1.2l5.8-5.7q1.2-1.2 1.1-2.8c0-1.6-.3-2-1-2.8l-4.4-4.2 2-3.6 1.5-3.9h6.5q1.5 0 2.8-1.1 1-1.2 1.1-2.8v-8.2q0-1.6-1.1-2.8a4 4 0 0 0-2.8-1.1h-6l-1.2-4-1.7-3.7 4.6-4.7q1.2-1 1.2-2.7 0-1.6-1.2-2.8zm45.3 44a2 2 0 0 0-1.6-.4 2 2 0 0 0-1.4.9l-2 2.7-2-.7-2.3-.5-.6-3.5a2 2 0 0 0-.9-1.4 2 2 0 0 0-1.6-.4l-4.5.8q-.8 0-1.3.9a2 2 0 0 0-.4 1.6l.6 3.2a16 16 0 0 0-4 2.3l-2.9-2a2 2 0 0 0-1.6-.4q-.8 0-1.4.9l-2.6 3.6a2 2 0 0 0-.3 1.7q0 .8.9 1.4l2.7 1.9-.7 2.1-.5 2.2-3.5.7a2 2 0 0 0-1.4.8 2 2 0 0 0-.4 1.7l.8 4.4q0 .8.9 1.4.7.5 1.6.4l3.2-.6a16 16 0 0 0 2.3 3.9l-2 3a2 2 0 0 0-.4 1.5q0 .8.9 1.4L89 92a2 2 0 0 0 1.7.3 2 2 0 0 0 1.4-.9l1.9-2.7a15 15 0 0 0 4.3 1.1l.7 3.6q0 .8.8 1.4.7.5 1.7.3l4.4-.7q.8-.2 1.4-.9a2 2 0 0 0 .3-1.6l-.5-3.3 2-1 1.9-1.3 3 2.1a2 2 0 0 0 1.5.4 2 2 0 0 0 1.4-1l2.6-3.6q.6-.7.4-1.6a2 2 0 0 0-.9-1.4l-2.7-2a15 15 0 0 0 1.1-4.3l3.6-.6a2 2 0 0 0 1.4-.9 2 2 0 0 0 .3-1.6l-.7-4.4q-.1-.8-1-1.4a2 2 0 0 0-1.5-.4l-3.3.6-1-2-1.3-1.9 2-3q.6-.7.5-1.6t-1-1.4zM99.2 64.8a8 8 0 0 1 3.1.1 8 8 0 0 1 2.8 1.2 8 8 0 0 1 2 2.2q1 1.4 1.2 3a8 8 0 0 1 0 3.1 8 8 0 0 1-1.3 2.8 8 8 0 0 1-2.2 2.1 8 8 0 0 1-3 1.1 8 8 0 0 1-3 0 8 8 0 0 1-2.8-1.3 8 8 0 0 1-2.1-2.2 8 8 0 0 1-1.2-3 8 8 0 0 1 0-3 8 8 0 0 1 1.3-2.8 8 8 0 0 1 2.2-2.1 8 8 0 0 1 3-1.2m-59-40.7a16 16 0 0 1 15 9.9 16 16 0 0 1 1.2 6.3 16 16 0 0 1-16 16 16 16 0 0 1-14.8-9.8 16 16 0 0 1-1.3-6.2A16 16 0 0 1 34 25.5a16 16 0 0 1 6.3-1.3"/>'
		],
		
		'wpcom' => [
			'box' => '0 0 24 24',
			'body' => '<path d="M4 12h16M4 8h16M4 16h8" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>'
		],
		
		'wpcs' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M418.6 21.3H221.4a93.4 93.4 0 0 0-93.4 93.4V128H93.4A93.4 93.4 0 0 0 0 221.3V310c0 55.3 26.4 95.3 76.9 95.3h8.4v64c0 23 31.3 29.7 40.8 8.9a136 136 0 0 1 35.1-44.6 224 224 0 0 1 41-28.3h75.1C330.2 405.3 384 361 384 310v-11.3h51.1c50.5 0 76.9-40 76.9-95.3v-88.7a93.4 93.4 0 0 0-93.4-93.4M277.3 362.7h-80.2q-4.7 0-9 2a266 266 0 0 0-60 41.4V384a21.5 21.5 0 0 0-21.4-21.3H76.9c-22.3 0-34.2-18.1-34.2-52.7v-88.7c0-28 22.7-50.6 50.7-50.6h200.8a50.7 50.7 0 0 1 47.1 50.6V310c0 25.3-33 52.7-64 52.7m192-159.3c0 34.5-11.9 52.6-34.2 52.6H384v-34.7a93.3 93.3 0 0 0-93.4-93.3h-120v-13.3c0-28 22.8-50.7 50.8-50.7h197.2c28 0 50.7 22.7 50.7 50.7z"/><path d="M192 234.7a21.3 21.3 0 1 0 0 42.6 21.3 21.3 0 0 0 0-42.6m85.3 0a21.3 21.3 0 1 0 0 42.6 21.3 21.3 0 0 0 0-42.6m-170.6 0a21.3 21.3 0 1 0 0 42.6 21.3 21.3 0 0 0 0-42.6"/>'
		],
		
		'wpd' => [
			'box' => '0 0 18 18',
			'body' => '<path fill-rule="evenodd" d="M5.58.05 5.7 0h11.22l.11.05.93.93.05.11v11.22l-.04.1-.94.94-.11.05h-5.8v-.16a1.6 1.6 0 0 0-.44-1.09h6.08V1.25H5.85v5.77A5 5 0 0 0 4.6 6.9V1.1l.05-.11zm7.56 7.5-2.22 2.21a2 2 0 0 0-.28-.37l-.33-.33 1.77-1.77-2.86-2.93.64-.66 3.28 3.27zm-5.51 3.17 1.05-1.05.84.84-1.37 1.37.18.17v1.2h1.19v1.14h-1.2v.08A5 5 0 0 1 8 15.62l1.52 1.54-.84.84-1.31-1.3A3.4 3.4 0 0 1 4.76 18a3.4 3.4 0 0 1-2.61-1.3L.85 18 0 17.16l1.52-1.54a5 5 0 0 1-.33-1.13v-.06H0v-1.19h1.19v-1.19l.17-.17L0 10.5l.84-.84 1.05 1.05a2.96 2.96 0 0 1 5.74 0m-1.61-.53a1.79 1.79 0 0 0-3.05 1.27h3.57a1.8 1.8 0 0 0-.52-1.26m.36 5.86a2.6 2.6 0 0 0 .76-1.62v-1.78H2.38v1.78a2.64 2.64 0 0 0 2.38 2.38 2.6 2.6 0 0 0 1.62-.76"/>'
		],
		
		'wpdb' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M88.94 124c37.7 12.74 90.12 20.31 148.34 20.31s110.69-7.56 148.35-20.31c33.07-11.04 53.73-24.43 53.73-37.52s-20.47-26.42-53.74-37.46C347.97 36.47 295.56 28.7 237.28 28.7S126.65 36.46 88.94 48.82c-70.14 23.45-72.05 50.9 0 74.98zm342.4 152.25a161.6 161.6 0 0 1 114.5 47.43 161.85 161.85 0 1 1-228.89 228.89 161.8 161.8 0 0 1 0-228.9 161.5 161.5 0 0 1 114.44-47.42zm9.19 85.57-13.72 68.59-13.68-20.62c-29.31 11.82-46.02 31.36-48.46 61.35-24.42-42.3-9.52-80.25 21.15-102.57l-13.97-21.01 68.39 14.17zM418.6 518.76l13.48-68.38L445.8 471c29.31-11.81 46.01-31.36 48.46-61.35 24.42 42.3 9.77 80.26-21.15 102.58l13.97 21-68.38-14.16zM527.92 341.9a136.77 136.77 0 1 0 40 96.56 136 136 0 0 0-40-96.56M221.26 444.47c-54.86-1.12-104.38-9.18-141.27-21.5a181 181 0 0 1-43.95-20.8v93.69c2.58 12.16 22.41 24.42 53.19 34.73 37.7 12.6 90.12 20.37 148.34 20.37h16.7a213 213 0 0 0 21.1 27.79q-18.45 1.07-37.8 1.07c-61.15 0-116.84-8.35-157.43-21.88-21.4-7.18-72.83-30.63-72.83-58.61v-9.43L6.73 86.48C6.73 59.71 34.67 37 80 21.9 120.44 8.33 176.12-.02 237.28-.02S354.12 8.33 394.71 21.9s68 33.8 72.49 57.49a14 14 0 0 1 .83 4.88v146.98a206 206 0 0 0-29.7-3.12 14 14 0 0 0 .83-4.55V130a181 181 0 0 1-44.6 21.11c-40.59 13.53-96.27 21.93-157.43 21.93-61.15 0-116.69-8.4-157.13-21.93a183 183 0 0 1-43.96-20.76v95.98c2.58 12.16 22.41 24.42 53.19 34.73 37.42 12.45 89.83 20.37 148.05 20.37 19.93 0 39.08-.93 57.35-2.64a199 199 0 0 0-8.8 8.01q-1.58 1.33-3.02 2.73a214 214 0 0 0-17.34 19.55c-9.23.39-18.56.58-28.1.58-61.24.44-116.93-7.9-157.37-21.49a181 181 0 0 1-43.96-20.76v93.69c2.59 12.16 22.42 24.42 53.19 34.73 34.44 11.48 81.14 18.95 133.4 20.17a210 210 0 0 0-1.17 22.22v6.45z"/>'
		],
		
		'wpdp' => [
			'box' => '0 0 24 24',
			'body' => '<path fill-rule="evenodd" clip-rule="evenodd" d="M8 10a4 4 0 1 1 8 0v1h1a3.5 3.5 0 1 1 0 7h-.1a1 1 0 1 0 0 2h.1a5.5 5.5 0 0 0 .93-10.922 6.001 6.001 0 0 0-11.86 0A5.502 5.502 0 0 0 7 20h.1a1 1 0 1 0 0-2H7a3.5 3.5 0 1 1 0-7h1zm5 1a1 1 0 1 0-2 0v5.586l-1.293-1.293a1 1 0 0 0-1.414 1.414l3 3a1 1 0 0 0 1.414 0l3-3a1 1 0 0 0-1.414-1.414L13 16.586z"/>'
		],
		
		'wpdpp' => [
			'box' => '0 0 600 600',
			'body' => '<path fill-rule="nonzero" d="M209.02 0h202.55a17 17 0 0 1 13.54 6.77l127.2 137.62a17 17 0 0 1 4.48 11.44l.1 294.63a75.2 75.2 0 0 1-22.18 53.2l-.08.09a75.2 75.2 0 0 1-53.17 22.13h-23.53a75.2 75.2 0 0 1-22.15 51.95A75.2 75.2 0 0 1 382.51 600H118.54c-20.73 0-39.6-8.5-53.26-22.17a75.2 75.2 0 0 1-22.16-53.25v-365.2a75.2 75.2 0 0 1 22.14-53.28 75.2 75.2 0 0 1 53.28-22.15h15.06v-8.53a75.2 75.2 0 0 1 22.15-53.27A75.2 75.2 0 0 1 209.02 0m35.81 294.37a16.94 16.94 0 0 1 0-33.86h200.82a16.94 16.94 0 0 1 0 33.86zm0 90.16a16.93 16.93 0 1 1 0-33.86h160.02a16.93 16.93 0 0 1 0 33.85zm176.35-332.4v57.5c1.13 14.44 6.11 25.7 14.84 33.16 9.15 7.8 22.97 12.2 41.32 12.54l39.17-.05zM523.03 189.1l-45.95-.07c-26.73-.41-47.82-7.63-63-20.61-15.82-13.54-24.76-32.68-26.59-56.34l-.16-2.35V33.85h-178.3a41.5 41.5 0 0 0-29.37 12.21 41.5 41.5 0 0 0-12.2 29.36v375.04c0 11.42 4.7 21.83 12.22 29.35a41.5 41.5 0 0 0 29.34 12.22h272.44a41.4 41.4 0 0 0 29.34-12.18 41.4 41.4 0 0 0 12.23-29.4zm-98.98 336.77H209.02a75.2 75.2 0 0 1-53.26-22.15 75.2 75.2 0 0 1-22.16-53.27V117.8h-15.06a41.5 41.5 0 0 0-29.36 12.21 41.5 41.5 0 0 0-12.21 29.36v365.2c0 11.42 4.7 21.81 12.22 29.34a41.5 41.5 0 0 0 29.35 12.24h263.97c11.4 0 21.8-4.7 29.34-12.24a41.4 41.4 0 0 0 12.2-28.03"/>'
		],
		
		'wpds' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M49.34 1.39c-2.6.95-5.93 2.96-7.6 4.5-6.52 6.05-6.28 2.73-6.28 89.33 0 90.75-.47 85.88 9.37 92.06l5.34 3.44h140.7V347.9c0 167.5-.12 162.64 5.34 164.78 1.06.35 27.04.7 57.65.7h55.63v33.46c0 18.5.6 35.46 1.19 37.72 1.42 5.34 8.9 12.7 14.35 14.24 5.7 1.66 218.4 1.54 224.33 0a24 24 0 0 0 8.06-4.4c7.35-6.16 7.12-3.2 7.12-77.8v-68.1l-2.73-4.03a29 29 0 0 0-6.64-6.65l-4.04-2.73H449.7l-26.33-13.05-26.33-13.17-37.01.36-37.13.36-4.27 3.31c-8.43 6.4-8.54 6.76-8.9 46.27l-.35 35.24h-99.53V302.47l3.9-.6c4.87-.95 89.46-.95 93.01 0 2.61.6 2.61.71 2.97 35.83l.35 35.35 3.2 4.75a23.6 23.6 0 0 0 8.3 7.35c5.23 2.5 5.58 2.5 115.79 2.5l113.76-1.31c4.04-1.54 9.5-6.53 11.75-10.8 1.42-2.6 1.66-14.82 1.66-70.34 0-74.85.23-72.24-8.07-78.65l-4.15-3.2-52.31-.6-52.32-.59-25.5-12.7-25.51-12.8H361.8c-33.22 0-35.23.11-40.21 2.49a23.6 23.6 0 0 0-8.3 7.35l-3.2 4.75-.36 35.47-.36 35.35h-99.53v-91.22l33.57-.36 33.7-.35 4.26-3.33c9.02-6.76 8.54-2.96 8.54-78.65V40.53l-3.33-4.98c-1.78-2.73-5.33-6.05-7.94-7.35-4.4-2.26-6.88-2.38-55.17-2.38h-50.53l-25.15-12.81L122.64.3 88.24.08c-26.92-.23-35.34 0-38.9 1.3m94.07 30.37 24.32 12.46 51.6.6 51.61.59v125.73l-108.19.36-108.3.24V18.59l32.38.35 32.27.36zm275.22 196.92 26.21 13.05h100.72v126.93l-108.2-.24-108.3-.36-.24-74.73.24-76.28c.36-1.07 7.83-1.42 31.91-1.42h31.32zm0 212.34 26.33 13.05h100.59V581l-108.19-.24-108.3-.35-.24-76.28-.24-76.16h63.82z"/>'
		],
		
		'wpdv' => [
			'box' => '0 0 122.9 112.4',
			'body' => '<path fill-rule="evenodd" d="M30 111.9c5.9 0 10.7-4.3 10.7-9.7q0-2.8-1.7-5.1h.3c-4.7-5.2-4.2-9.4.8-11h16.6c1.9 0 3.4-1.4 3.4-3.3V68c1.1-10 5.4-7 10.5-4C82.8 71.6 90.9 54 81 47.8c-7.7-4.8-11 3.4-16.7 2.5C62 50 60.6 47.6 60 44V29.6c0-1.9-1.5-3.4-3.4-3.4H42.2c-6.9-.9-8.2-5.5-2.9-11.3H39q1.7-2.3 1.7-5.2C40.7 4.3 36 0 30 0S19.2 4.3 19.2 9.6q0 3 1.7 5.2c5.2 5.8 4 10.5-3 11.3H3.5A3.4 3.4 0 0 0 0 29.5v15.2c1 6.2 5.6 7.2 11.2 2.1q2.3-1.6 5.2-1.6c5.3 0 9.6 4.8 9.6 10.7s-4.3 10.8-9.6 10.8q-3 0-5.2-1.7v.3C5.6 60.2 1 61.2 0 67.4v15.4c0 1.9 1.5 3.4 3.4 3.4H20c5 1.5 5.5 5.7.8 10.9a9 9 0 0 0-1.6 5.2c0 5.3 4.8 9.6 10.8 9.6m63 .5c-6 0-10.8-4.3-10.8-9.6q.1-3 1.7-5.2c4.7-5.2 4.2-9.4-.8-10.9H66.3a3.4 3.4 0 0 1-3.4-3.4V68c.8-2.3 1.9-3.1 3-3.2q.9 0 1.8.4c1.8.8 3.8 2.3 6 3.1 8.6 3.3 16-5 15.4-13.6q-.1-2.8-2-5.5c-4.4-6.7-10.8-7.3-17-3.5-3.2 2-5.8 3.4-7.2-1.2V30.1c0-2 1.6-3.4 3.5-3.4h14.5c6.9-1 8.2-5.5 2.9-11.3a9 9 0 0 1-1.7-5.2C82.1 4.9 87 .5 93 .5s10.8 4.4 10.8 9.7q0 2.9-1.7 5.2c-5.2 5.8-4 10.4 3 11.3h14.5c1.9 0 3.4 1.5 3.4 3.4v15.1c-1.1 6.3-5.6 7.3-11.2 2.1v.1a9 9 0 0 0-5.2-1.7c-5.3 0-9.6 4.8-9.6 10.8s4.3 10.8 9.6 10.8q3-.1 5.2-1.7v.3c5.6-5.2 10.1-4.1 11.2 2v15.4c0 1.9-1.5 3.4-3.4 3.4H103c-5 1.5-5.6 5.7-.8 10.9h-.1q1.6 2.3 1.7 5.2c0 5.3-4.8 9.6-10.8 9.6" clip-rule="evenodd"/>'
		],

		'wpf' => [
			'box' => '0 0 14 14',
			'body' => '<path d="M1.2 12.994a.312.312 0 0 1-.188-.191C1 12.76.999 12.113 1 6.982V1.208l.022-.045a.328.328 0 0 1 .14-.14L1.208 1h11.585l.05.025a.31.31 0 0 1 .136.135l.021.039v5.783c0 5.377 0 5.787-.013 5.831a.314.314 0 0 1-.142.162L12.8 13H7.012c-3.457.001-5.8 0-5.817-.01zm11.236-5.992V1.568H1.573v10.857c0 .01 1.099.01 5.436.01h5.432V7.003zM5.574 10.72v-.86h1.712v1.72H5.574v-.86zm1.144 0v-.284h-.576v.568h.576v-.284zm1.145 0v-.284h3.432v.568H7.863v-.284zM5.574 7.572V6.428h5.72v2.288h-5.72V7.572zm5.144 0V7H6.142v.566c0 .311 0 .569.01.572 0 0 1.033.01 2.288.01h2.282v-.572zm-8 0v-.289h2.28v.577h-2.28v-.288zM5.575 4.14V2.996h5.72v2.288h-5.72V4.14zm5.144 0v-.572H6.142v.566c0 .31 0 .568.01.572 0 0 1.033.01 2.288.01h2.282v-.572zm-8 0v-.284h2.28v.567h-2.28V4.14z"/>'
		],
		
		'wpfc' => [
		'box' => '0 0 29.922 29.922',
		'body' => '<path d="M5.262 8.517a.235.235 0 0 0 .186-.37L4.327 6.522 4.26 4.549a.237.237 0 0 0-.371-.186L2.264 5.484l-1.972.067a.235.235 0 0 0-.186.37l1.121 1.625.067 1.973a.235.235 0 0 0 .37.186l1.625-1.121zm3.692 1.624-.471-.86c-.042-.075-.121-.123-.207-.123s-.166.048-.207.123l-.471.86-.86.471a.237.237 0 0 0 0 .414l.86.472.471.859a.237.237 0 0 0 .414 0l.471-.859.86-.472a.237.237 0 0 0 0-.414zm-2.699-6.55 1.625.004 1.367.88a.237.237 0 0 0 .364-.198l.004-1.625.88-1.367a.235.235 0 0 0-.198-.363L8.673.919 7.306.039a.234.234 0 0 0-.364.196l-.004 1.626-.88 1.367a.24.24 0 0 0-.009.241.23.23 0 0 0 .206.122m5.928 3.444.718-.089.653.312a.236.236 0 0 0 .336-.242l-.089-.718.312-.653a.24.24 0 0 0-.021-.24.24.24 0 0 0-.221-.095l-.718.089-.653-.312a.236.236 0 0 0-.336.243l.089.718-.312.652a.235.235 0 0 0 .242.335M29.421 18.38l-.815-.814-9.084-9.084a1.5 1.5 0 0 0-1.062-.438 1.499 1.499 0 0 0-1.062 2.559l8.757 8.757 1.144 1.143a1.5 1.5 0 1 0 2.122-2.123m-9.409-6.58-1.905-1.905a.501.501 0 0 1 .708-.707l1.904 1.905zM5.027 20.311v8.122c0 .822 2.854 1.489 6.375 1.489s6.375-.667 6.375-1.489v-8.122c-1.805.403-4.05.63-6.375.63-2.325-.001-4.571-.227-6.375-.63m6.375-5.502c-5.316 0-9.625 1.148-9.625 2.565 0 .764 1.261 1.448 3.25 1.918 1.699.401 3.927.646 6.375.646s4.676-.246 6.375-.646c1.989-.471 3.25-1.154 3.25-1.918 0-1.416-4.309-2.565-9.625-2.565m0 4.154c-3.291 0-5.958-.711-5.958-1.588s2.667-1.589 5.958-1.589 5.958.711 5.958 1.589c0 .876-2.668 1.588-5.958 1.588"/>'
		],
		
		'wpfd' => [
		'box' => '0 0 25 25',
		'body' => '<path d="m5 12.5h15m-11.5 7 4-4 4 4m0-14-4 4-4-4" stroke="#121923" stroke-width="1.2"/>'
		],
				
		'wpff' => [
		'box' => '0 0 1024 1020',
		'body' => '<g transform="matrix(.1 0 0 -.1 0 1020)"><path d="M1913 9531c-237-82-379-406-440-1006-19-195-22-646-5-860 57-694 225-1282 501-1744 57-97 60-104 44-117-311-245-648-367-1149-419-107-11-144-49-144-144 0-37 7-57 29-87 39-54 194-200 264-249 31-22 57-43 57-46s-39-23-87-44c-263-114-302-139-334-210-10-22-19-53-19-70 0-69 80-187 260-385 102-112 120-138 145-205 72-199 346-536 660-813 335-295 690-533 1340-897 629-352 900-532 1138-755 152-143 307-341 386-496 62-120 90-150 151-159 63-8 105 17 158 96 57 86 83 110 182 178 308 210 684 387 1317 620 1111 408 1761 768 2327 1289 111 102 274 274 365 386 41 50 91 95 158 142 121 85 330 291 361 355 22 45 27 109 14 157-11 36-96 144-205 259-156 165-146 145-89 182 63 40 158 140 178 186 30 72-22 157-104 170-263 44-473 120-643 235-128 87-316 260-366 337-15 22-15 26 3 48 10 13 68 83 127 157 538 665 890 1477 1002 2308 33 244 30 548-6 695-46 184-141 299-277 335-49 13-115 7-407-37-570-84-1139-265-1662-528l-223-112v51c0 61-28 112-65 122-14 3-82 1-150-5-69-6-265-11-436-11s-376-5-456-11c-79-6-146-9-149-6s9 49 27 104c53 163 44 240-38 314-65 59-91 65-186 45-201-43-509-169-664-272-87-58-302-262-425-404l-56-65-79 76c-108 104-313 292-403 370-419 361-981 699-1436 864-255 93-385 113-491 76m213-292c283-74 782-324 1195-599 198-133 569-420 594-460 10-16 173-150 182-150 5 0 24-16 43-35l34-35-33-37c-17-21-53-67-79-102-96-131-107-144-122-151-8-4-53-25-99-46l-84-39-46 55c-196 234-566 558-837 733-231 149-666 367-733 367-30 0-71-56-71-97 0-43 37-80 136-138 35-21 66-41 68-44s-11-64-29-136c-84-330-68-605 61-1035 71-235 207-658 241-747l35-91-53-79c-28-43-99-145-157-227l-106-148-23 26c-13 15-23 33-23 40 0 8-21 51-46 97-159 287-297 735-365 1184-78 513-69 1155 22 1545 12 52 23 105 24 118 1 12 7 28 13 34 7 7 12 18 12 25 0 15 53 120 72 143 20 24 61 50 78 50 9 0 52-9 96-21m7009-609c32-20 48-47 61-105 4-16 12-36 18-44 16-20 20-335 6-451-92-767-413-1539-921-2217-55-73-103-134-108-137-8-6-79 110-181 294-29 52-59 104-66 115-23 32-17 52 33 113 109 133 336 508 453 747 85 175 138 308 169 430 29 111 61 335 61 425v75l66 38c70 41 204 161 204 182 0 8-12 27-26 44-20 24-34 31-61 31-52 0-539-165-753-255-336-141-865-437-996-557-23-21-44-38-47-38s-35 14-71 30c-36 17-90 36-120 42-48 9-59 8-81-6-14-10-29-24-32-32-7-20 70-99 254-260 163-143 275-260 373-389 96-128 275-444 439-775 198-403 296-560 464-747 222-248 438-396 697-481 87-28 118-37 205-57l30-7-35-18c-19-10-39-16-43-13s-16 1-25-3-33-8-52-9c-74-4-197-28-250-48-65-26-78-55-35-83 15-10 31-28 36-41s17-27 26-30c25-9 261-210 356-302 91-88 113-122 97-151-15-28-130-118-257-201-204-134-404-215-648-264-71-15-134-30-139-35-16-16 3-41 48-61 52-23 235-43 320-36l59 5-49-50c-130-132-374-327-594-473-461-306-845-493-1625-791-438-168-659-257-808-325-257-118-594-295-714-376l-122-82-47 67c-179 254-474 523-829 757-168 110-460 285-796 476-530 301-874 527-1179 773-96 77-294 252-343 304l-39 40 79-21c63-16 111-20 250-21l171-1 44 30c91 65 58 99-189 194-227 87-389 169-536 271-143 100-471 390-456 404 2 2 65 30 139 64 141 63 475 219 522 244 67 36 114 139 71 155-10 4-28 14-40 23s-59 27-105 39c-46 13-93 28-104 33-12 6-35 11-50 13-31 3-127 44-158 68-17 12-12 14 57 20 147 13 371 74 489 133 21 11 79 40 130 66 202 102 509 387 713 664 58 78 164 238 258 391 81 131 217 319 299 414 26 30 48 60 48 66 0 17 234 247 325 320 129 103 383 266 474 303 53 22 99 49 125 74 23 22 59 55 81 74s101 92 176 163c214 202 499 436 598 491 20 11 43 26 52 34 8 8 47 30 85 49s76 39 84 43c33 19 128 59 185 79 33 12 76 28 96 36l35 16-23-72c-34-104-42-115-103-157-31-21-81-59-111-85-30-25-91-69-137-97-100-62-172-123-172-148 0-32 26-43 83-36 28 4 61 7 72 7s66 22 122 49c56 28 107 50 113 50s27 7 48 16c20 9 55 18 76 20 22 2 45 9 51 14 7 6 26 7 43 4 17-4 39-3 49 1s149 6 309 5c257-1 511 11 554 27 8 3 40 6 71 8 31 1 63 6 70 11 8 5 26 9 40 9 25 0 25-1-19-52-56-64-160-155-232-202-30-19-140-74-245-121-287-130-300-138-293-182q3-22.5 42-42c38-19 39-18 173 8 96 18 188 46 312 92 164 62 305 127 317 146 3 4 11 8 19 8 7 0 65 31 129 69 139 83 394 209 566 281 69 29 136 58 150 65 37 19 437 149 570 185 63 17 119 35 126 40 6 6 13 7 16 4 4-3 53 6 110 19 56 14 128 31 158 37 30 7 59 15 63 17 5 3 30 6 56 8 27 1 54 6 61 10s41 9 77 10c35 1 68 6 73 11s64 10 131 12c107 2 125 0 154-18m-6460-384c221-131 505-338 674-492 69-63 211-221 211-235 0-4-31-27-69-49-39-23-75-48-82-56-9-12-16-7-39 28-80 127-285 361-371 424-54 40-74 42-106 12-34-31-29-63 17-116 45-51 85-110 175-262 33-56 79-130 102-166l43-64-41-38c-23-20-44-38-48-40-3-1-26 32-51 74s-73 107-106 143c-58 62-63 65-90 56-58-21-113-121-155-285-24-93-29-286-10-345 8-21 14-52 13-67-1-27-30-88-43-88-3 0-16 46-29 103-12 56-53 197-91 314-142 440-185 660-176 898 5 133 25 245 58 323l19 44 32-20c18-10 92-53 163-96m5790-507c-44-323-150-659-284-900-62-111-307-485-340-518-18-18-19-15-24 178-6 213-22 408-37 446-16 43-60 32-254-65-43-22-56-17-79 29-12 25-10 29 38 82 84 92 213 257 235 300 12 23 20 54 18 72-2 27-8 33-31 35-44 5-124-54-273-200l-130-128-30 31c-16 17-50 47-76 67l-47 36 37 25c207 141 703 401 972 510 133 54 313 120 318 116 1-1-5-53-13-116m-5451-598c20-19 36-39 36-44 0-9-48-67-123-151l-28-31 6 120c3 66 8 141 11 168l6 47 28-37c15-21 44-54 64-72m4611-539c-2-3-65 92-73 110-2 4 12 13 30 21l33 14 6-71c3-39 5-72 4-74"/><path d="M3515 6164c-109-24-190-69-270-149-127-128-175-243-122-293 38-36 63-28 141 47 39 37 90 80 113 94 102 64 242 84 354 51 173-51 286-161 405-392 65-127 91-153 163-160 43-4 50-2 74 28 35 41 43 75 27 119-27 77-111 235-166 312-70 97-199 222-278 268-122 73-309 104-441 75m3405-294c-135-23-246-89-371-217-125-129-237-300-255-390-8-41 16-75 67-98 61-28 81-16 190 120 164 205 266 285 401 315 113 25 244-34 368-165 133-141 126-137 177-106 45 28 49 63 18 152-99 285-329 435-595 389m-1765-519c-49-13-74-16-83-9-8 7-60 9-145 5-168-7-348-50-384-92-26-30-29-53-9-61 7-3 53 2 102 10s132 20 184 26 103 13 113 16c17 5 16 2-5-38-18-34-23-59-23-123 0-112 36-185 141-285 69-65 104-87 202-126 24-10 23-10-36-90-33-45-86-102-117-128-124-101-297-182-449-212-157-31-302 6-380 98-36 41-66 118-66 165 0 37-28 83-50 83-24 0-44-29-69-101-23-69-59-138-110-214-70-103-49-150 53-121 30 9 57 16 60 16 7 0 13-42 26-200 15-172 39-311 91-536 115-496 249-867 388-1075 64-96 200-227 271-262 120-59 208-55 340 14 189 98 395 324 588 644 121 201 305 622 428 979 56 164 58 169 93 183 20 9 56 28 79 44 38 26 50 29 91 23 62-8 76 7 62 67-14 59-14 138 0 229 14 90-3 175-35 175-14 0-25-22-50-96-56-164-95-214-185-239-96-27-262 0-390 63-208 103-404 285-450 419l-19 55 62 17c85 24 191 93 269 176 90 95 101 118 102 212 0 43 3 78 6 78 21 0 249-79 320-111 112-51 144-57 169-34 29 26 25 39-21 79-96 81-270 149-467 182-54 8-158 36-232 61-129 44-141 47-265 50-104 2-144-1-200-16m-164-2075c8-4 30-48 48-99 76-212 94-246 126-233 24 9 42 63 66 193 11 65 23 120 25 122 9 10 185-42 251-74 79-39 173-130 173-168 0-42-87-213-175-347-128-195-312-372-442-427-32-13-40-13-79 2-103 39-198 149-297 342-86 168-187 435-187 492 0 24 114 132 168 160 68 35 149 51 232 47 41-2 82-7 91-10"/><path d="M4043 3399c-25-38-28-52-31-146-6-172 42-457 127-749 105-362 184-516 345-678 136-136 261-186 469-186 253 0 427 68 629 244 103 89 200 212 254 321 72 147 93 266 54 305-41 41-52 30-140-130-79-145-135-226-224-319-91-95-158-144-262-193-142-66-290-84-437-53-93 19-157 57-231 135-121 128-212 305-296 571-95 302-159 587-184 808-14 125-28 138-73 70"/></g>'
		],
		
		'wpfm' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M11.23 261.522h150.392v-7.324c0-30.518 24.95-55.469 55.469-55.469h55.517c30.518 0 55.47 24.951 55.47 55.469v7.324h140.869c6.152 0 11.23 5.03 11.23 11.23v36.67H137.012c-6.299 0-13.867 5.128-16.894 11.427L9.18 550.586A11.206 11.206 0 0 1 0 539.599V272.753a11.23 11.23 0 0 1 11.23-11.23zm177.98 0h111.28v-6.299c0-15.673-12.794-28.515-28.516-28.515h-54.249c-15.674 0-28.515 12.842-28.515 28.515zm-40.723 69.092h443.898c6.25 0 9.424 5.225 6.543 11.377L482.96 588.623C480.08 594.775 472.95 600 466.7 600H22.803c-6.299 0-9.424-5.225-6.543-11.377l115.967-246.632c2.88-6.152 9.961-11.377 16.26-11.377"/>'
		],
		
		'wphi' => [
			'box' => '0 0 116.5 122.9',
			'body' => '<path d="M17.9 22.8a2 2 0 0 1 3 .5l1.1 1.4 3.8-5a2.2 2.2 0 1 1 3.4 2.9l-5.6 7-.5.6a2.2 2.2 0 0 1-3.1-.6l-2.7-3.8a2 2 0 0 1 .6-3M81 59a27.9 27.9 0 0 1 23.3 43.1l12.1 13.1-8.3 7.6-11.6-12.7A27.9 27.9 0 1 1 81 59M38.5 71.5a3 3 0 0 1-3-3.1 3 3 0 0 1 3-3.2h9a3 3 0 0 1 2.9 3.2 3 3 0 0 1-3 3.1ZM93 45c-.6 2.1-5.3 2.4-6.4 0V7.4l-.3-.7-.7-.3H7.4a1 1 0 0 0-1 1v88.3a1 1 0 0 0 1 1h30.3c3.2.4 3.3 6 0 6.5H7.4A7.5 7.5 0 0 1 0 95.7V7.4a7 7 0 0 1 2.2-5.2A7 7 0 0 1 7.4 0h78.2a7 7 0 0 1 5.2 2.2A7 7 0 0 1 93 7.4zM38.4 27.5a3 3 0 0 1-2.9-3.2 3 3 0 0 1 3-3.2h29.7a3 3 0 0 1 3 3.2 3 3 0 0 1-3 3.2Zm0 22a3 3 0 0 1-2.9-3.2 3 3 0 0 1 3-3.2h29.7a3 3 0 0 1 3 3.2 3 3 0 0 1-3 3.2Zm32.2 40-.3-.5-.3-.6a3.5 3.5 0 0 1 5-4.4l.6.4c1 1 1.3 1.1 2.4 2l.9 1 7.6-8.2c3.2-3.3 8.3 1.5 5 4.9l-9.3 10.2-.5.5a3.6 3.6 0 0 1-5 .2l-.7-.7-1.8-1.6zm10.6-24.7A22.2 22.2 0 1 1 59 87a22 22 0 0 1 22.2-22.2m-57.7-1.2a5.1 5.1 0 1 1-5 5 5 5 0 0 1 5-5M25.7 42a2 2 0 0 1 3 0 2 2 0 0 1 0 3l-2.1 2.1 2 2.2a2.1 2.1 0 0 1-3 3l-2-2.1-2 2a2 2 0 0 1-3 0 2 2 0 0 1 0-3l2-2-2-2.2a2 2 0 0 1 0-3 2 2 0 0 1 3 0l2 2.1z" fill-rule="evenodd"/>'
		],
		
		'wpht' => [
			'box' => '0 0 600 600',
			'body' => '<path fill-rule="nonzero" d="M361.1 129.2c-4.5 5.5-7.3 12-8.6 18.5a54 54 0 0 0 1.8 26.9 9 9 0 0 1-5.9 11.4 10 10 0 0 1-2.8.5H76.3v362.1c.5 12.4 2.5 20.9 7.3 25.7s13 7 26.5 7.3h281.5v-83c6.8-.5 13.2-3 18.3-7v26.6h50.8c5 0 9 4 9.1 9 .5 26.5-2.9 45.2-13.6 57.4s-27.6 16.9-53.6 15l-1.8.2H109.9c-18.6-.3-31-4.2-39.3-12.7-8.4-8.6-11.8-21-12.6-38V186.4H9a9 9 0 0 1-9.1-9.1v-1.2a91 91 0 0 1 10.6-40.6l.4-.5a53 53 0 0 1 27.8-23.7 9 9 0 0 1 3.1-.5h316.6c15 .2 28 2.6 37.5 10.8s14.8 21.6 13.9 42.9v72.3a170 170 0 0 0-18.2 12.5v-85.2c.6-15.2-2.2-24-7.6-28.7-5.1-4.4-13.2-6-23-6.3m-23.6 333c-7.3 23-18 45.2-19.8 67.8l12.8-2.2c15.5-60.6 30.5-101.7 66.1-154.6a354 354 0 0 1 96-98.6c21-14.3 48.1-30.3 73.3-35.9a97 97 0 0 1 21-2.3c-77 24.4-136 71.2-180.6 137.7a574 574 0 0 0-47.3 88.1l30.3 3-12.9-5.2 44-10.7c-17-4.5-33.2-1.2-39-7 45.7-5.9 82.5-18.8 107.4-40.2-10-.6-21.4-.9-27.5-3.2 43-18.6 66.4-47.6 97-74.1-41.5 12.3-80.7 14-92.7 6.9 75-.6 121.5-25 133.7-78.4q1.6-8.6-.4-17c-8.8-36.7-75.6-43.9-94.5-11.7-3.8 6.5-9.3 12.6-13.8 20l17.3-39.8c-53.3 23-56.1 43.7-79.5 107.5a190 190 0 0 1 10-52.8c-66.3 32-83.7 100.3-82.7 157.2-3.6-19.6-2-44.7 2.8-73-18.3 21.6-30 46.2-22.5 79.4l-9.4-3.4 6.2 17.6-14.2-5.3zm-198 14.7a9.1 9.1 0 0 1 0-18.2h115.7a9 9 0 0 1 0 18.2zm0-55.3a9 9 0 0 1 0-18.2h149c5 0 9 4.1 9 9.1s-4 9.1-9 9.1zm-3.4-55.2c-5.2 0-9.5-4-9.5-9s4.3-9.2 9.5-9.2h176.7c5.2 0 9.5 4.1 9.5 9.1s-4.3 9.1-9.5 9.1zm3.2-55.3a9 9 0 0 1-9.1-9c0-5 4-9 9-9h189c5 0 9 4 9 9s-4 9-9 9zm.3-55a9.1 9.1 0 0 1 0-18.4h188.8a9.1 9.1 0 0 1 0 18.3zm270.3 280.3v45.3c16.3.5 26.7-2.4 32.6-9.2 6.2-7 8.8-19 9.1-36zM334.5 144q1.5-7.6 5-15h-296c-7.5 3.1-13 8.5-16.9 15.1l-.2.5q-5.9 10.5-7.5 23.5h315.2q-1.9-11.9.4-24"/>'
		],
		
		'wplf' => [
			'box' => '0 0 24 24',
			'body' => '<path d="M15 4h7v2h-7zm1 4h6v2h-6zm2 4h4v2h-4zM9.3 4l-6 16h2.14l1.88-5h6.36l1.88 5h2.13l-6-16zm-1.23 9 2.43-6.48L12.93 13z"/>'
		],
		
		'wpll' => [
			'box' => '0 0 512 512',
			'body' => '<path d="m336.406 166.563-76.5 12.094h-7.812c-3.906 0-65.61-10.344-76.5-12.094-18.72-3.03-34.345 2.266-39.814 4.531-22.969 9.531-15.25 31.813-10.156 40.064 7.047 11.344 33.781 41.125 60.125 44.609 34.345 4.516 64-21.172 70.25-21.172 6.235 0 35.907 25.688 70.25 21.172 26.345-3.484 53.095-33.266 60.126-44.61 5.094-8.25 12.813-30.53-10.156-40.063-5.485-2.266-21.094-7.563-39.813-4.53zm-151.75 54.422c-11.095-10.735-9.25-21.517 3.687-22.392 12.97-.906 34.814 4.5 35.173 11.656.922 17.908-27.767 21.502-38.86 10.736m142.688 0c-11.11 10.766-39.797 7.172-38.86-10.735.36-7.156 22.204-12.563 35.142-11.656 12.968.875 14.812 11.656 3.718 22.39zm75.406-105.079c0-5.03-5.219-15.094-14.578-17.125C374.656 19.156 296.562 0 256 0c-40.563 0-118.657 19.156-132.188 98.781-9.375 2.031-14.563 12.094-14.563 17.125v33.25H402.75zm-46.031 266.329c0-20.203-6.281-42.297-26.234-42.297H181.499c-19.938 0-26.234 22.094-26.234 42.297 0 4.797-93.359 28.828-93.359 82.656 0 12.516 30.422 47.11 193.032 47.11h2.109c162.625 0 193.047-34.595 193.047-47.11 0-53.827-93.375-77.86-93.375-82.656"/>'
		],
		
		'wplalo' => [
		'box' => '0 0 21 21',
		'body' => '<g fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"><path d="M15.5 7.6q0 3 1.5 5.4a1.7 1.7 0 0 1-1.4 2.5H5.4A1.7 1.7 0 0 1 4 13q1.5-2.5 1.5-5.4V6.5a4 4 0 0 1 4-4h2a4 4 0 0 1 2.2.6"/><path d="M10.5 5.5h2l-2 3h2m2-7h3l-3 4h3M13 17q-1 1.5-2.5 1.5C9 18.5 8.7 18 8 17"/></g>'
		],

		'wplu' => [
			'box' => '0 0 96.108 122.88',
			'body' => '<path clip-rule="evenodd" d="M2.892 56.036h8.959V37.117c0-10.205 4.177-19.484 10.898-26.207v-.009C29.473 4.177 38.754 0 48.966 0 59.17 0 68.449 4.177 75.173 10.901l.01.009c6.721 6.723 10.898 16.002 10.898 26.207v18.919h7.136a2.9 2.9 0 0 1 2.892 2.891v61.062a2.9 2.9 0 0 1-2.892 2.891H2.892A2.9 2.9 0 0 1 0 119.989V58.927a2.9 2.9 0 0 1 2.892-2.891m23.379 0h45.387V36.911c0-6.24-2.554-11.917-6.662-16.03l-.005.004c-4.111-4.114-9.787-6.669-16.025-6.669-6.241 0-11.917 2.554-16.033 6.665-4.109 4.113-6.662 9.79-6.662 16.03zm22.878 33.412 4.581 21.139-12.557.053 3.685-21.423c-3.431-1.1-5.918-4.315-5.918-8.111a8.512 8.512 0 1 1 10.209 8.342"/>'
		],

		'wpmt' => [
			'box' => '0 0 512 512',
			'body' => '<path d="M121.5 64.2c-31.7 0-57.3 25.7-57.3 57.3 0 31.7 25.7 57.3 57.3 57.3 31.7 0 57.3-25.7 57.3-57.3.1-31.7-25.6-57.3-57.3-57.3zm0 94.3c-20.4 0-37-16.6-37-37s16.6-37 37-37 37 16.6 37 37-16.5 37-37 37z"/><path d="M244.5 29.8c-10.4-11.5-25-17.7-40.7-17.7L96.5 11C73.6 11 51.7 19.3 36 36 19.3 51.7 11 73.6 11 96.5l1 107.4c1 14.6 6.3 29.2 17.7 40.7L286.2 501 501 286.2 244.5 29.8zm40.7 442L43.3 229.9c-7.3-7.3-11.5-16.7-11.5-27.1l-1-106.3c0-16.7 7.3-33.4 18.8-45.9 12.5-12.5 29.2-19.8 46.9-19.8l106.3 1c10.4 0 19.8 4.2 27.1 11.5l241.9 241.9-186.6 186.6z"/>'
		],

		'wpmc' => [
			'box' => '0 0 96 96',
			'body' => '<path fill="#fe5200" d="M95.5 79 85.2 61.7H75L85.2 79 75 96h10.3z"/><path fill="#fe5200" d="M70.2 79 59.9 96h10.3l10.3-17-10.3-17.2H59.9z"/><path fill="#fe5200" d="M44.9 61.8 55.2 79 44.9 96h10.3l10.2-17-10.2-17.2z"/><path fill="#fe5200" d="m41.6 94 9-15-9-15.2-3.5-5.8h28.1A33.3 33.3 0 1 0 41 95zm-3.4-55-.1 12.3c-4.7-.4-9.3 1-12.8 3.9l-8.8-8.8A26 26 0 0 1 38.2 39M10 58.3a23 23 0 0 1 2.4-6.5l10 6.8a15 15 0 0 0-2 4.9A17 17 0 0 0 20 68l-9.7 1.8a24 24 0 0 1-.4-11.5m12.5 26.1a24 24 0 0 1-9.8-9.3l8-3.2a17 17 0 0 0 5 7.5zm6 2-1.4-.3 1.8-4.4a17 17 0 0 0 4.5 1.6 20 20 0 0 0 8.2 0l.4 2a24 24 0 0 1-13.5 1.2"/>'
		],
		
		'wpmcl' => [
			'box' => '0 0 122.9 97.7',
			'body' => '<path d="M0 0h122.9v97.7H0zm34.6 25.4a8 8 0 1 1 0 16 8 8 0 0 1 0-16m33.6 34.3 16-27.6 17 43H21.9v-5.4l6.7-.3L35.2 53l3.4 11.7h10l8.6-22.3zM9.2 8.1h104.6v81.5H9z" fill-rule="evenodd" clip-rule="evenodd"/>'
		],

		'wpmi' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M26 0H6a2 2.286 0 0 0-2 2.286v4.571a2 2.286 0 0 0 2 2.286h9v7.051l-2.59-2.948L11 14.857l5 5.714 5-5.714-1.41-1.611L17 16.194V9.143h9a2 2.286 0 0 0 2-2.286V2.286A2 2.286 0 0 0 26 0M6 2.286h4v4.571H6zm20 4.571H12V2.286h14zm0 16H6a2 2.286 0 0 0-2 2.286v4.571A2 2.286 0 0 0 6 32h20a2 2.286 0 0 0 2-2.286v-4.571a2 2.286 0 0 0-2-2.286M6 25.143h14v4.571H6zm20 4.571h-4v-4.571h4z"/><path fill="none" d="M0 0h32v32H0z"/>'
		],
		
		'wpmin' => [
		'box' => '0 0 797 797',
		'body' => '<g transform="matrix(.1 0 0 -.1 -365 909.6)"><path d="M7390 8744c-279-19-378-28-526-49-415-58-777-147-1204-297-223-78-283-109-365-192-112-113-170-252-169-406 1-78 7-103 74-305 190-575 291-1050 352-1655 19-195 22-281 22-640 0-355-3-447-22-640-63-636-177-1161-386-1775l-71-210 1-115c0-100 4-124 27-182 48-124 130-223 235-285 128-76 542-234 807-310 189-53 498-121 630-138 28-3 73-11 100-16 88-16 364-39 583-49 840-35 1758 142 2429 471 147 72 227 143 285 254 97 187 92 285-32 640-176 501-300 1090-357 1690-28 294-25 979 5 1285 35 352 85 683 133 872l19 77-36 78c-20 43-67 148-106 233-67 148-156 339-248 535-24 50-59 126-80 170-82 176-108 231-241 503-76 155-141 282-144 282-4 0-68 13-143 29-309 67-527 101-802 127-150 14-658 26-770 18m765-704c140-13 376-46 483-67l84-16-6-31c-3-17-15-130-26-251s-31-339-45-485-28-297-31-336l-7-70 119-13c154-17 668-102 679-113 2-2-7-76-20-163-30-200-62-499-75-715-13-210-13-854 0-1115 32-657 131-1344 274-1908 29-116 39-170 32-176-27-20-329-119-519-170-619-167-1386-219-2052-141-259 31-587 90-755 136-197 55-251 71-390 116-85 28-159 54-164 59-5 4 11 83 38 186 145 557 231 1097 277 1753 17 228 17 1097 1 1330-41 581-128 1147-273 1768-10 45-19 87-19 91 0 14 232 96 430 152 354 100 758 165 1205 193 106 7 646-3 760-14"/><path d="M7390 6913c-25-1-119-7-210-13-228-15-716-63-760-76-13-3-14-19-7-116 4-62 9-113 10-115 2-1 45 4 97 12 187 28 489 56 718 67l232 12-6 105c-6 114-9 132-21 129-4-1-28-3-53-5m-446-883c-290-39-473-319-474-727-1-373 149-620 408-674 65-13 241-7 286 10l29 12-7 112c-4 61-9 114-12 116-2 3-21-1-42-9-49-17-138-16-184 4-129 55-190 195-190 436 0 250 53 389 174 456 64 35 152 39 206 10 19-9 36-15 39-13 2 3 13 56 23 118 14 85 15 116 7 121-39 26-174 39-263 28m689-5c-130-36-215-105-267-215-28-60-30-74-31-170 0-97 2-110 31-170 41-87 87-135 224-238 131-99 160-138 160-217 0-101-80-165-206-165-52 0-82 6-122 25-30 14-57 25-62 25-6 0-40-191-40-226 0-6 26-20 58-30 87-29 296-26 374 5 171 67 268 210 268 395-1 164-79 285-260 404-138 91-189 155-176 225 21 112 165 162 293 102l53-24 5 22c11 52 35 195 35 209 0 43-234 72-337 43m823 4c-233-55-366-280-298-506 36-117 89-178 264-303 43-31 89-71 103-90 74-101 42-223-72-266-59-23-172-15-232 15-31 16-46 19-51 11-9-15-44-219-38-225 2-3 40-14 83-25 199-51 403-5 514 115 74 82 95 143 95 285 1 105-1 120-26 173-41 88-97 148-211 225-56 39-120 89-142 112-38 39-40 44-40 104 0 50 4 69 20 86 53 60 162 76 260 39 31-12 58-19 60-17 6 5 35 181 35 209 0 20-7 30-27 38-73 29-216 39-297 20M6436 4125c-4-64-6-118-4-120 3-3 269-30 458-46 198-17 1110-23 1354-10 207 12 493 34 590 47l49 6-5 114c-3 63-7 117-10 119-3 3-49-2-104-10-280-42-856-70-1264-62-397 8-678 29-1016 74l-41 5zm1478-426c-108-13-204-79-240-165-19-44-18-146 1-192 30-70 83-111 202-156 40-15 87-37 105-50 63-42 62-110-1-153-41-28-135-31-222-9-31 8-62 16-69 18-13 3-22-24-35-108l-6-42 68-20c104-32 179-37 252-18 86 22 127 43 169 85 51 53 72 104 72 184 0 138-62 207-239 268-30 11-69 30-88 45-27 21-33 32-33 64 0 46 31 75 89 86 32 6 126-5 187-22 18-5 23 2 41 68 24 86 21 91-61 107-82 15-127 18-192 10m-597-15c-4-4-7-148-7-321 0-346-4-373-57-394-16-6-53-8-88-5l-61 6-15-77c-12-55-13-80-6-85 19-12 133-20 178-13 116 19 196 84 227 185 14 47 17 102 17 380v325l-90 3c-50 1-94 0-98-4m-697-478v-86h-421l3-72 3-73 208-3 207-2v-80c0-44 2-80 5-80 11 0 355 232 355 239s-62 49-337 229l-23 14zm1925-32c-93-62-170-118-170-123 0-8 340-241 352-241 1 0 3 36 3 80v80h410v150h-410v85c0 47-3 85-7 84-5 0-84-52-178-115M4610 6410v-480h-960V4340h960v-455c0-250 4-455 8-455 7 0 67 185 172 525 10 33 57 184 105 335 47 151 106 338 130 415s65 207 90 288l47 148-32 102c-18 56-60 192-95 302-58 182-275 883-361 1165-20 63-40 130-46 148-5 17-11 32-14 32-2 0-4-216-4-480m5870-83c-90-292-179-579-197-637-17-58-63-206-102-329l-70-225 59-180c95-292 470-1505 470-1521 0-8 5-15 10-15 7 0 10 160 10 460v460h960v1590l-480 2-481 3 1 463c0 254-3 462-7 462-5 0-82-240-173-533"/></g>'
		],
		
		'wpmtm' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M314.485 110.567c-13.047-5.088-26.519-7.744-40.41-7.744-20.894 0-38.077 6.685-51.549 19.942l-116.25 116.143 12.094 12.202-44.126 44.44L0 221.192l44.121-44.126 13.682 13.364L173.415 74.927c15.908-15.8 32.988-23.652 51.23-23.652 30.655 0 60.567 19.731 89.84 59.292m176.413-32.886c12.636 0 24.765 2.154 36.055 6.104L498.27 114.83c-65.162 70.494 8.374 111.28 73.174 62.886l24.995-18.662a109.3 109.3 0 0 1 3.56 27.73c0 60.259-48.843 109.107-109.107 109.107a108.6 108.6 0 0 1-54.034-14.302l-52.989 56.256 149.64 143.214-67.666 67.666a336625 336625 0 0 1-141.515-147.667l-92.911 98.624a40.674 40.674 0 1 1-66.705-46.114l-.058-.058.356-.308a40.9 40.9 0 0 1 10.41-8.926l104.498-89.58L151.08 219.752l53.463-53.458 139.513 133.42 57.93-49.669a108.6 108.6 0 0 1-20.196-63.257c0-60.265 48.843-109.108 109.108-109.108zm-351.102 24.19-53.14 53.14-10.186-10.18 53.14-53.146z"/>'
		],

		'wpocb' => [
			'box' => '0 0 122.88 85.75',
			'body' => '<path d="M114.69 36.31v48a1.45 1.45 0 0 1-1.44 1.44h-12.41a1.45 1.45 0 0 1-1.44-1.44v-35.7c2.54-2.48 5.65-5.48 8.83-8.54l5-4.82a13 13 0 0 0 1.45 1.06zm-84.56-13a21 21 0 0 0-8.08 1h-.06A20.87 20.87 0 0 0 8.34 48.78a21 21 0 0 0 1.79 4.93l-9.82 9.4a1 1 0 0 0 0 1.41l5.56 5.82a1 1 0 0 0 1.41 0l9.45-9.12a21 21 0 0 0 4.63 2.47 22 22 0 0 0 6 1.3 20.9 20.9 0 0 0 21.15-27.48 20.9 20.9 0 0 0-18.38-14.17zm-12.38 8.31a16.65 16.65 0 0 1 23.52 1.6v.05a17 17 0 0 1 3.19 5.59A16.7 16.7 0 0 1 34 60a17 17 0 0 1-6.44.82 16 16 0 0 1-6.28-1.69 17 17 0 0 1-5.1-4l-.05-.06a17 17 0 0 1-3.2-5.59v-.05a17 17 0 0 1-.8-6.39 16.6 16.6 0 0 1 5.66-11.43zm28.59-8.08 11-9.6c7.26 7.12 14.3 15.72 21.49 22.82L105 10.43 96.55 2l26.33-2-1.48 26.83-8.1-8.1c-5.81 5.89-19.55 18.86-25.37 24.68-7.35 7.35-10.86 7.49-18.21.13L57.3 29.73l-3.86 3.42a29 29 0 0 0-1.37-2.7 26 26 0 0 0-3-4.18 26 26 0 0 0-2.77-2.72zm18.42 31.34v29.43a1.45 1.45 0 0 1-1.44 1.44H50.91a1.45 1.45 0 0 1-1.44-1.44V62.92a29 29 0 0 0 2.12-2.44 27 27 0 0 0 2.91-4.66 27 27 0 0 0 2.65-8.6l3.31 3.68.43.45a51 51 0 0 0 3.87 3.53m-25 14.5v14.93a1.45 1.45 0 0 1-1.44 1.44H25.94a1.45 1.45 0 0 1-1.44-1.44V70.93a30 30 0 0 0 3.08.38 29 29 0 0 0 10.78-1.4c.48-.17 1-.34 1.43-.53zm49.96-12.31v27.24a1.45 1.45 0 0 1-1.44 1.44H75.87a1.45 1.45 0 0 1-1.44-1.44v-24.4a19 19 0 0 0 4.54.46 20 20 0 0 0 10.75-3.3" fill-rule="evenodd"/>'
		],

		'wppo' => [
			'box' => '0 0 512 512',
			'body' => '<path d="m243.86.015-6.937.168C157.567 3.487 106.556 50.096 85.958 101.65c-12.677 31.725-13.35 65.2-1.964 91.423 11.386 26.224 34.136 45.887 72.454 51.594 20.413 3.04 40.503 6.352 59.9 10.245 64.846-27.12 77.123-77.815 93.809-124.216 8.376-23.295 17.626-45.763 36.682-61.095 13.816-11.118 32.263-17.483 56.821-17.861-30.874-22.08-67.165-38.33-107.312-46.47C277.7 1.489 260.21-.15 243.86.01zm159.698 71.744c-20.619.262-34.017 5.52-43.994 13.548-13.881 11.168-22.23 29.569-30.355 52.165-14.311 39.795-28.77 91.826-82.033 124.315 45.52 11.29 85.47 26.956 113.91 51.223 23.136 19.74 38.273 45.923 40.508 78.45 1.668 24.256-3.574 51.734-16.515 83.237C494.515 395.112 525.711 294.41 506.841 205.88c-10.649-49.952-37.52-96.141-76.177-132.1-10.23-1.49-19.21-2.122-27.106-2.021M69.612 88.409C47.434 95.337 24.127 107.155.002 124.7L0 512h250.019c12.092-25.124 21.463-50.406 28.36-75.453-37.41-1.238-72.961-13.577-102.405-33.494-52.967-35.837-87.16-96.802-78.24-160.914-14.557-11.008-25.4-25.148-32.318-41.08-13.959-32.142-12.616-70.88 1.759-106.857a167 167 0 0 1 2.436-5.796zm156.65 29.25c25.354 0 45.923 20.454 45.923 45.693 0 25.24-20.569 45.696-45.922 45.696s-45.889-20.455-45.889-45.696c0-25.24 20.536-45.695 45.889-45.695zm-109.34 136.073c-3.79 52.76 25.32 102.158 70.424 132.672 48.399 32.744 114.02 43.07 176.144 10.415-6.56-1.066-12.826-2.476-18.817-4.214-14.31-18.996-21.72-45.9-20.237-68.138a75.5 75.5 0 0 1 1.624-11.36c-5.793-3.35-11.966-6.523-18.511-9.5-1.798 6.221-2.868 12.786-3.316 19.511-1.235 18.513 2.177 38.497 9.95 56.713-38.864-22.047-60.01-59.776-63.048-95.84-29.897-8.05-63.158-14.237-97.665-19.376-13.536-2.017-25.73-5.75-36.548-10.886z"/>'
		],

		'wppp' => [
			'box' => '0 0 800 800',
			'body' => '<path fill-rule="evenodd" d="M435.68 132.302c66.672 7.032 127.55 33.727 176.707 74.095l33.922-35.42c6.902-7.227 18.491-7.357 25.718-.39l22.789 22.137c7.162 6.967 7.292 18.491.39 25.653l-34.833 36.331c46.553 57.492 74.485 130.74 74.485 210.434C734.858 650.052 584.911 800 400 800c-184.91.065-334.858-149.882-334.858-334.793 0-83.47 30.601-159.844 81.126-218.507l-39.196-36.852c-7.292-6.837-7.487-18.426-.585-25.653l21.941-22.984c6.902-7.227 18.426-7.422 25.654-.586l41.735 39.261a332.55 332.55 0 0 1 181.2-68.625V58.599h-64.459c-8.594 0-15.626-7.032-15.626-15.627V15.626C296.932 7.032 303.964 0 312.558 0h187.515c8.595 0 15.626 7.032 15.626 15.626v27.346c0 8.595-7.031 15.627-15.626 15.627h-64.458v73.703zm-62.96 210.37h28.582c5.209 0 9.506 4.296 9.506 9.505v119.476h87.963c5.209 0 9.506 4.297 9.506 9.506v28.583c0 5.209-4.297 9.506-9.506 9.506H363.213v-167.07a9.52 9.52 0 0 1 9.506-9.507zM400 193.31c150.142 0 271.897 121.755 271.897 271.897S550.142 737.104 400 737.104 128.103 615.35 128.103 465.207 249.858 193.31 400 193.31"/>'
		],

		'wppr' => [
			'box' => '0 0 512 278.862',
			'body' => '<path d="M115.895 82.821l24.793 24.794-28.549 28.549-25.202-25.202c-33.462 38.969-53.685 89.641-53.685 145.037H0C0 185.311 28.655 121.31 74.982 74.982 121.311 28.655 185.311 0 256.001 0c55.455 0 106.794 17.638 148.714 47.607l-26.682 22.017c-29.756-19.522-64.47-32.111-101.845-35.468v29.067h-40.377V34.156c-45.225 4.064-86.554 21.642-119.916 48.665zm117.429 138.04c-38.905 32.142 13.13 86.243 48.237 40.188L440.178 63.123l-7.426-6.826-199.428 164.564zM450.497 89.547C488.837 134.304 512 192.448 512 255.999h-33.252c0-53.029-18.531-101.73-49.467-139.979l21.216-26.473z"/>'
		],

		'wprt' => [
			'box' => '0 0 512 512',
			'body' => '<path d="m256 23-11.1.3.8 18q5-.3 10.3-.3A215 215 0 1 1 57.4 338.4l27.6-8.3-48.5-34.3-19 54.5 22.5-6.7A233.1 233.1 0 1 0 256 23m-30.8 2a232 232 0 0 0-38.6 8.5l5.6 17.1q17.2-5.3 35.4-7.7zm-57 15.2q-18.6 7.5-35.4 18l9.5 15.3q15.5-9.6 32.6-16.7zm-51.8 29.3a234 234 0 0 0-29.3 26.1l13 12.3q12.5-13.2 27-24l-4.8-6.6zm69.5 8.6-4.4 17.4 217 55.5 4.4-17.4zM74.1 110.5a234 234 0 0 0-22 32.7l15.7 8.8q8.9-16 20.2-30.3zm127.6 8.8c-3.9 26 2.8 55.2 14.2 79.2a146 146 0 0 0 21.9 33.8q6.4 7 12.2 10.9l-5.4 21.2q-7 .6-16 3.7a143 143 0 0 0-35.4 19.1c-21.6 15.6-41.4 37.9-50.4 62.6l167.5 42.9c3.9-26-2.8-55.2-14.2-79.2a146 146 0 0 0-21.9-33.8 69 69 0 0 0-12.2-10.9l5.4-21.2q6.9-.7 16-3.7a143 143 0 0 0 35.4-19.1c21.6-15.6 41.4-37.9 50.4-62.6zM43.2 160.9q-8 18-13 37.3l17.5 4.2q4.5-17.7 12-34.2zm-17 56.6Q23.1 236.3 23 256v.9l18-.2v-.7q0-18.2 3-35.6zM113.5 361l-4.4 17.4 217 55.5 4.4-17.4z"/>'
		],

		'wps' => [
			'box' => '0 0 18 18',
			'body' => '<path d="M2.455 18a.82.82 0 0 1-.819-.818v-2.455a.819.819 0 0 1 1.637 0v2.455a.82.82 0 0 1-.818.818m7.363-.818v-5.727a.819.819 0 0 0-1.636 0v5.727a.819.819 0 0 0 1.636 0m5.727-9a.82.82 0 0 0-.817.818v8.182a.819.819 0 0 0 1.636 0V9a.82.82 0 0 0-.819-.818m.313-8.119A.8.8 0 0 0 15.545 0h-3.272a.819.819 0 0 0 0 1.636h1.297L9 6.207 6.305 3.513a.82.82 0 0 0-1.157 0L1.876 6.785A.819.819 0 0 0 3.033 7.94l2.695-2.694L8.422 7.94a.82.82 0 0 0 1.156 0l5.15-5.149V4.09a.819.819 0 0 0 1.636 0V.818a.82.82 0 0 0-.506-.755"/>'
		],

		'wpsh' => [
			'box' => '0 0 32 32',
			'body' => '<path d="M16 1.151c-8.88 0-16 7.182-16 16.156 0 1.328.052 1.833.328 3.104l4.88 3.615.76 6.021h8.135l.438.302c.5.349.938.5 1.443.5.469 0 .974-.135 1.365-.417l.521-.385h8.125l.75-6.021 4.927-3.615c.276-1.271.328-1.776.328-3.104 0-8.969-7.12-16.156-16-16.156m1.328 3.01c1.198 0 2.37.297 3.349.865l-3.286 16.729 4.563-16.078c1.411.479 2.479 1.25 3.344 2.417l.031.047-6.536 14.151L26.22 9.344l.047.036c1.01.943 1.661 2.089 1.99 3.531l-8.26 10.224 8.583-8.667.01.026a7.1 7.1 0 0 1 .557 2.661c0 .677-.031.948-.219 1.667l-4.74 3.469-.62 4.948h-5.969l-.688.526c-.266.208-.646.354-.911.354s-.646-.146-.911-.354l-.688-.526H8.427l-.589-4.813-4.839-3.557a6.6 6.6 0 0 1-.214-1.677c0-.964.214-1.99.568-2.74l.016-.031 8.604 8.734-8.307-10.328c.333-1.417 1.167-2.786 2.188-3.62l7.391 13.036L6.641 8.134c.74-1.089 1.932-1.943 3.391-2.438L14.6 21.79 11.142 5.087l.073-.042c1.083-.599 2.13-.875 3.276-.875.26 0 .38.005.703.042l.781 17.401.615-17.417c.297-.031.411-.036.74-.036z"/>'
		],

		'wpsi' => [
			'box' => '0 0 18 18',
			'body' => '<g stroke="currentColor"><path d="m20.75 17.75h-8m-12 0h8m2-2v-3" stroke-linecap="round" transform="matrix(.8372 0 0 .8372 0 .78)"/><circle cx="8.9999" cy="15.6403" fill="none" r="1.6744" stroke-width=".8372"/><path d="m12.75 12.75h-9a3 3 0 1 1 0-6h14a3 3 0 1 1 0 6h-1m-6-12h7a3 3 0 1 1 0 6h-14a3 3 0 1 1 0-6h3m5 3h6m-6 6h6" fill="none" stroke-linecap="round" transform="matrix(.8372 0 0 .8372 0 .78)"/></g><circle cx="3.9767" cy="3.1395" r=".8372" stroke-width=".8372"/><circle cx="3.9767" cy="8.1627" r=".8372" stroke-width=".8372"/>'
		],
		
		'wpssl' => [
			'box' => '0 0 95.17 122.88',
			'body' => '<path d="M20.59 47.11H88.8a6.4 6.4 0 0 1 6.37 6.37v7.78H0v-7.78a6.4 6.4 0 0 1 6.37-6.37zm74.58 19.78v49.61a6.4 6.4 0 0 1-6.37 6.38H6.37A6.4 6.4 0 0 1 0 116.5V66.89Zm-83.12 38.38 1.23-7.22a30 30 0 0 0 7.24 1 42 42 0 0 0 5.19-.26v-2.18l-3.94-.35q-5.34-.48-7.33-2.56t-2-6.15q0-5.6 2.43-7.7t8.25-2.1a47 47 0 0 1 10.5 1.09l-1.1 7a43 43 0 0 0-6.52-.65 32 32 0 0 0-4.15.22v2.14l3.15.31q5.73.57 7.92 2.73a8 8 0 0 1 2.19 6 13 13 0 0 1-.75 4.66 8 8 0 0 1-1.77 2.89 7 7 0 0 1-2.91 1.51 17 17 0 0 1-3.3.63q-1.42.12-3.79.11a46 46 0 0 1-10.55-1.14Zm26.24 0 1.22-7.22a30 30 0 0 0 7.24 1 42 42 0 0 0 5.19-.26v-2.18L48 96.26q-5.34-.48-7.33-2.56-1.99-2.07-2-6.15 0-5.6 2.43-7.7t8.25-2.1a47 47 0 0 1 10.5 1.09l-1.09 7a43 43 0 0 0-6.52-.66 33 33 0 0 0-4.16.22v2.14l3.15.31q5.73.57 7.92 2.73a8 8 0 0 1 2.19 6 13 13 0 0 1-.75 4.66 8 8 0 0 1-1.77 2.89 7 7 0 0 1-2.91 1.51 17 17 0 0 1-3.3.63q-1.42.12-3.79.11a46 46 0 0 1-10.54-1.14Zm44.83.49H65.61V78.41h8.76v20.34h8.75v7ZM6.37 47.11" fill-rule="evenodd"/><path d="M74.58 47.11v-6.63a29 29 0 0 0-8-20.16 26 26 0 0 0-38 0 29 29 0 0 0-8 20.16v6.63H8.52v-6.63A41 41 0 0 1 19.92 12a37.93 37.93 0 0 1 55.33 0 41 41 0 0 1 11.4 28.5v6.63Z" fill-rule="evenodd"/>'
		],

		'wpsm' => [
			'box' => '0 0 122.88 82.43',
			'body' => '<path class="st0" d="M5.53 0h85.4c1.52 0 2.91.62 3.91 1.62s1.63 2.39 1.63 3.91v5.66c-.76-.46-1.51-.93-2.25-1.39-.66.52-1.33 1.01-2 1.49V7.22L79.39 18.15a50.853 50.853 0 0 1-9.46 2.5L89.19 4.24H6.96L48.98 38.5l7.85-6.69c.08 1.8.19 3.55.34 5.27l-6.79 5.78c-.76.65-1.9.69-2.71.03l-10.2-8.32L6.61 65.51h57.7c.7 1.47 1.45 2.89 2.25 4.25H5.54c-1.52 0-2.91-.62-3.91-1.63-1-1-1.62-2.39-1.62-3.91V5.53c0-1.52.62-2.91 1.62-3.91S4.01 0 5.53 0zm117.22 29.08c1.44 29.04-9.29 46.2-28.3 53.35-18.36-6.7-29.21-23.11-28.4-53.79 9.65.5 19.12-1.58 28.3-8.71 8.14 5.16 18.52 10.05 28.4 9.15zm-8.8 7.02c.98 19.8-6.33 31.5-19.29 36.38-.08-.03-.16-.06-.25-.09v-42.4l.17-.12c5.54 3.51 12.62 6.84 19.37 6.23zm5.55-4.49c1.27 25.7-8.22 40.89-25.04 47.23C78.2 72.91 68.6 58.38 69.3 31.22c8.56.45 16.94-1.39 25.05-7.71 7.21 4.57 16.41 8.9 25.15 8.1zM4.24 61.89l29.93-30L4.24 7.49v54.4z"/>'
		],

		'wpsmc' => [
			'box' => '0 0 31.4 31.41',
			'body' => '<path d="m30.68 27.1-2.79-2.77a7.11 7.11 0 0 0-11.48-7.98 7.1 7.1 0 0 0 0 10.06 7.1 7.1 0 0 0 7.97 1.43l2.78 2.78a2.48 2.48 0 1 0 3.52-3.51m-6-2.48a4.6 4.6 0 0 1-6.5 0 4.6 4.6 0 0 1 0-6.5 4.6 4.6 0 0 1 6.5 0 4.6 4.6 0 0 1 0 6.5"/><path d="m21.72 4.6-1.24-1.1L19 3.2l-.03.67 1.44 1.4.7.83-.8.41-.64-.19-.96-.4.03-.78-1.26-.52-.42 1.83-1.28.29.13 1.02 1.66.32.29-1.63 1.37.2.63.37h1.02l.7 1.4 1.86 1.89-.14.73-1.5-.2-2.58 1.31-1.8 2.17a8 8 0 0 1 4-1.06 8 8 0 0 1 5.75 2.38 8.2 8.2 0 0 1 2.23 7.16 15.5 15.5 0 0 0 1.75-7.16c0-3.2-.97-6.2-2.64-8.67l-.46.15-2.48.22-.7 1.12-.51-.16-1.98-1.78-.29-.93zm-7.7 10.77.3 1.28.52-.6.5-.03.35-.38.45-.42-.92-.42zm6.06 14-.55.38-.29 1.03a16 16 0 0 0 3.75-1.45 8 8 0 0 1-1.56.16q-.68 0-1.35-.12m-4.39-2.25a8 8 0 0 1-2.37-5.74q.01-1.9.82-3.56l-1.66-.38-.86-1.8v1.07h-.38l-2.23-3.03V11.2L7.37 8.54 4.77 9H3.02l-.88-.58 1.12-.9-1.12.27A15.5 15.5 0 0 0 0 15.64 15.58 15.58 0 0 0 17.54 31.1l-.17-1.89.18-.7a8 8 0 0 1-1.86-1.38M5.8 5.08l2.77-.38L9.84 4l1.43.41 2.3-.13.78-1.23 1.15.19 2.78-.27.77-.84 1.08-.72 1.53.23.55-.09a15.5 15.5 0 0 0-6.63-1.5A15.5 15.5 0 0 0 3.56 5.73h.01zm10.45-3.47 1.6-.88 1.01.59-1.48 1.13-1.4.14-.64-.41zm-4.71.12.7.3.92-.3.5.87-2.12.56-1.03-.6s1-.64 1.03-.83"/>'
		],
		
		'wpsmx' => [
			'box' => '0 0 122.9 100.2',
			'body' => '<path d="M98.7 78.4h6.4V62.2q0-.5-.4-.8-.3-.3-.8-.3H65.3v17.3h6.3c2 0 3.7 1.6 3.7 3.6v14.5c0 2-1.7 3.7-3.7 3.7H51.1c-2 0-3.6-1.7-3.6-3.7V82c0-2 1.6-3.6 3.6-3.6h6.3V61H19q-.5 0-.8.3t-.4.8v16.2h6.4c2 0 3.7 1.6 3.7 3.6v14.5c0 2-1.7 3.7-3.7 3.7H3.6c-2 0-3.6-1.7-3.6-3.7V82c0-2 1.6-3.6 3.6-3.6H10V62.2a9 9 0 0 1 9-9h38.6V21.8H51c-2 0-3.6-1.6-3.6-3.6V3.6C47.4 1.6 49 0 51 0h20.6c2 0 3.6 1.6 3.6 3.6v14.6c0 2-1.6 3.6-3.6 3.6h-6.4v31.4H104a9 9 0 0 1 9 9v16.2h6.4c2 0 3.6 1.6 3.6 3.6v14.5c0 2-1.6 3.7-3.6 3.7H98.8c-2 0-3.7-1.7-3.7-3.7V82c0-2 1.7-3.6 3.6-3.6" fill-rule="evenodd" clip-rule="evenodd"/>'
		],

		'wpsr' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M122.9 267.9a195 195 0 0 0 74.3 129.4 191 191 0 0 0 25 16.4 103 103 0 0 0 17.6-24.5 87 87 0 0 0 5-12.5 151 151 0 1 1 127.9 5.4 189 189 0 0 1 7.6 44.5 194 194 0 0 0 62.2-35.9l112.3 87L600 413l-109.2-84.2a194.8 194.8 0 1 0-368-61M0 599.9V429.6h74a89 89 0 0 1 32.8 5.3 43 43 0 0 1 20 14.7 38 38 0 0 1 6.8 22.5 36 36 0 0 1-15.7 30.3 44 44 0 0 1-17.3 7.2v1.7a44 44 0 0 1 20 5.7 38 38 0 0 1 14.4 14 41 41 0 0 1 5.3 21 44 44 0 0 1-7.2 25 49 49 0 0 1-20.7 16.8 74 74 0 0 1-32 6.2zm46.3-37H68a29 29 0 0 0 17.4-4.3 15 15 0 0 0 5.9-12.9 18 18 0 0 0-2.8-10.2 17 17 0 0 0-7.8-6.3 30 30 0 0 0-12-2.1H46.2zm0-64.5h19a28 28 0 0 0 10.7-2 17 17 0 0 0 7.3-5.4 15 15 0 0 0 2.7-9 14 14 0 0 0-5.7-12 23 23 0 0 0-14.3-4.3H46.4v32.7zm252.5-252.5h31.7l-15.2-50.6H314zM340 277h-50.5l-8.8 29.3h-45L286.2 153h57l50.5 153.3h-44.9zM183.7 583l-2-146.6 37 36.3c55-37 80.6-84.2 72.6-146.9 68 76.4 54.3 160.6 1 219.5l37.7 37-146.5.6z"/>'
		],

		'wpsv' => [
			'box' => '0 0 600 600',
			'body' => '<path fill-rule="nonzero" d="M160.9 0h217.6a9.1 10.7 0 0 1 7.3 4.3l110.7 140.4a9 10.6 0 0 1 2.5 7.2v378c0 19.1-6.8 36.7-17.7 49.4S455.5 600 439.1 600H160.9c-16.4 0-31.4-8-42.3-20.6a76 76 0 0 1-17.6-49.6V70.2c0-19.3 6.7-36.9 17.6-49.6A56 56 0 0 1 160.9 0m-41.6 397.2h361.4v-224h-45.2v-.1h-.1c-21.9-.4-39-7.2-51.2-19.4-12.6-12.7-19.7-30.8-21.2-53.3a9.1 10.7 0 0 1 0-1.5V21.4H160.9c-11.4 0-21.8 5.5-29.4 14.4s-12.2 21-12.2 34.4zM480.7 419H119.3v111a53 53 0 0 0 12.2 34.3c7.6 8.9 18 14.4 29.4 14.4h278.2c11.3 0 21.8-5.6 29.3-14.4a53 53 0 0 0 12.3-34.4zm-84.6-120v-4.4H389v-25h33.5V324a96.1 112.6 0 0 1-34.2 7.4q-23.9 0-32.8-13.6-4.6-7-6.4-16.5c-1.8-9.4-1.8-14-1.8-23.4q0-14 1.9-23.3t6.7-16.4q9.2-13.7 35.6-13.7 5.4 0 14.1 1.3t12.8 3l-4.2 24.9q-11.3-2.3-20.4-2.3c-9.2 0-10.4.5-12.9 1.6q-3.6 1.7-3.6 6.6v46.1h9.1q5 0 7.4-1.2t2.3-5.6m-84.1-72h29.4l-21.6 102H279l-21.6-102H287l11.8 64.8h1.3zM177.5 327.1l3.9-27q12.8 3.8 23 3.8c10.3 0 12.4-.3 16.5-1v-8.1l-12.5-1.3q-17-1.8-23.3-9.5t-6.4-23q0-20.9 7.8-28.7t26.2-7.8c18.5 0 23.5 1.3 33.5 4l-3.5 26.2q-13-2.5-20.8-2.5c-7.8 0-9.6.3-13.2.8v8l10 1.2q18.3 2 25.2 10.2 7 8 7 22.4 0 10.3-2.4 17.4-2.3 7-5.6 10.8-3.3 3.6-9.3 5.6c-6 2-7.5 2-10.5 2.4s-7 .4-12 .4q-18.2 0-33.6-4.3m44 183.5c-5.2 0-9.5-5-9.5-11s4.3-11 9.5-11h153.2c5.2 0 9.5 4.9 9.5 11s-4.3 11-9.5 11zM381.3 30v68.9q1.6 25.1 14.8 38.5 13.5 13.7 39.4 14.3h41.8z"/>'
		],

		'wpt' => [
			'box' => '0 0 99.41 122.88',
			'body' => '<path d="m65.17 59.23 21.97 25.83c3.21 3.8 7.56 9.92 10.1 16.04 1.52 3.67 2.42 7.38 2.1 10.72a10.7 10.7 0 0 1-5.88 8.93 20 20 0 0 1-7.25 2.11l-.28.02h-72.4q-.22 0-.44-.04a20 20 0 0 1-7.14-2.09 10.7 10.7 0 0 1-5.91-9.02c-.28-3.35.67-7.1 2.25-10.81C5.01 94.58 9.64 88.2 12.9 84.34l21.21-25.12V28.65a17 17 0 0 0-.65-2.29 23 23 0 0 0-3.52-6.46 2.52 2.52 0 0 1 2.01-4.03h8.39a7.03 7.03 0 0 1 3.7-13.01 7.03 7.03 0 0 1 3.7 13.01H67.5a2.52 2.52 0 0 1 1.81 4.27 16 16 0 0 0-2.51 3.88q-1.01 2.15-1.63 4.7zM55.75 74.6h16.54L60.9 61.95a2.5 2.5 0 0 1-.77-1.81v-31.7q0-.29.07-.58a30 30 0 0 1 2.54-6.94h-26.2a27 27 0 0 1 2.5 6.8q.1.35.1.72v31.71c0 .57-.2 1.15-.6 1.62C29.51 72.62 12.6 90.32 7.23 102.9c-3.77 7.04-.97 16.08 6.72 15.76h71.86q3.33-.43 5.26-1.5c4.15-1.71 3.84-12.34 2.16-14.14q-.48-1.15-1.04-2.3-.22.05-.44.05H67.4c-1.27 0-2.32-1.18-2.32-2.62s1.04-2.62 2.32-2.62h21.84a70 70 0 0 0-3.71-5.26q-.17.03-.34.03h-18.2c-7.07 0-6.14-5.24-1.97-5.24h16.17l-4.66-5.47a2 2 0 0 1-.96.24H55.75c-3.06.01-3.06-5.23 0-5.23M26.03 25.71a4.83 4.83 0 1 1 0 9.67 4.83 4.83 0 0 1 0-9.67M22.29 0a8.57 8.57 0 1 1 0 17.15 8.57 8.57 0 0 1 0-17.15"/>'
		],

		'wpta' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M497 116.4a103 103 0 0 1 103 103.1 102.7 102.7 0 0 1-103 103 102.7 102.7 0 0 1-103-103 102.7 102.7 0 0 1 103-103M158.2 211q2.6.1 5.3-.4l-.7-5.3.1-1.4q0-1.6-.6-2.8l-4.3-33.8q4.2-16 12.8-25.2 8.9-9.5 22.2-12c11.8-.8 15.3 7.8 27 15.2 35.8 22.9 66 30.6 110.2 31.1l-5 25.4a7 7 0 0 0-2.7 6.4 7 7 0 0 0 .9 2.8l-.4 1.7h1.7a7 7 0 0 0 5.8 2.1q10.9-1 12.5 2 2.4 4.5-4.8 21l-24 39.7c-9 14.7-18 29.5-29.5 40.2a59 59 0 0 1-42.6 16.9 58 58 0 0 1-40.3-16.2c-11-10.1-20-24-28.6-37.6l-21.4-34.1-.1-.2a50 50 0 0 1-10-24.2q0-3 .8-5.2a8 8 0 0 1 2.7-3q3.5-2.4 10.5-2.7 1.4 0 2.5-.4m14.5 160.7 38.4 112.8 19.3-67-9.5-10.3q-6.4-9.3-2.8-16.3c5.1-10.2 15.7-8.3 25.6-8.3 10.4 0 23.2-2 26.4 11 1.1 4.4-.3 9-3.3 13.6l-9.5 10.4 19.3 67 34.8-113c25 22.6 99.3 27.2 126.9 42.5a75 75 0 0 1 23 19.5 93 93 0 0 1 17 50.4l5.8 91.2c-1.4 15-9.8 23.5-26.5 24.8h-431C9.8 598.7 1.3 590.1 0 575.2L5.8 484q2.6-31.4 17.1-50.4a72 72 0 0 1 23-19.5c27.6-15.3 101.8-19.9 126.8-42.4M345.1 201l1.3-54.3a83 83 0 0 0-21-52.6c-29.2-31.6-83.8-39.7-125-24.8Q190 73.2 181 78.9a82 82 0 0 0-36.2 46.2A78 78 0 0 0 142 139a543 543 0 0 0 .9 60q-3.3 1-5.8 2.9a22 22 0 0 0-7.8 9 26 26 0 0 0-2.2 11.8c.2 9 4.4 19.9 12.3 31.8l21.5 34.1a192 192 0 0 0 31.1 40.6c13 12 29 20 50.2 20a73 73 0 0 0 52.6-20.9c12.9-12 22.5-27.6 32-43.2l24.4-40.3.5-.8c6.8-15.5 8.2-26.4 4.6-33.7A18 18 0 0 0 345 201m163.6 37v-5.9q.2-1 1.2-1.1l44 3-44 5.2q-1-.2-1.2-1.2m-17.4-15.3c6.9 0 12.4 5.5 12.4 12.4a12.3 12.3 0 0 1-12.4 12.3 12.4 12.4 0 0 1 0-24.7M486 215h10.5a1.2 1.2 0 0 0 1.1-1.2l-6-44-6.7 44q.1 1 1.1 1.2m69.5-54.3a83 83 0 0 0-58.6-24.3 83 83 0 0 0-58.7 24.3 83 83 0 0 0-24.3 58.7 82.6 82.6 0 0 0 83 83 82.7 82.7 0 0 0 83-83c0-22.9-9.3-43.7-24.4-58.7"/>'
		],

		'wpu' => [
			'box' => '0 0 122.92 122.92',
			'body' => '<path d="M64.892 32.65l-5.08 25.85-5.16-7.77c-11.11 4.46-17.35 11.81-18.27 23.13-9.13-16-3.59-30.25 8-38.63l-5.29-7.93zM61.442 0a61.46 61.46 0 1 1-43.44 18 61.21 61.21 0 0 1 43.44-18zm36.12 25.32a51.08 51.08 0 1 0 15 36.12 51 51 0 0 0-15-36.12zM56.642 91.8l5.08-25.8 5.16 7.77c11.12-4.51 17.35-11.86 18.27-23.18 9.13 16 3.59 30.25-8 38.63l5.26 7.93z" fill-rule="evenodd"/>'
		],

		'wpur' => [
			'box' => '0 0 600 600',
			'body' => '<path d="M287.9 0c-33.8 0-51 1-79.8 20.2-42.7 28.1-68.8 76.9-79.8 144.5-2.3 33.7-3.8 92 19.8 119.1l27.5-.6 13-.4 19.8 23a316 316 0 0 0 14.6 16c-3.7 5.5-20.2 19.5-34.8 31.8l-17.3 15c-37.1 14.4-73.4 29.2-101.5 46.9C30.1 440 10.3 481 1 525.5c-2.9 39 0 37 27.4 36.6l364.8 1.1q-2.5-25 5-52c12.8-45.1 45.7-83.4 87.2-107.2a803 803 0 0 0-82.7-35.9l-11-9.7a345 345 0 0 1-31.8-29.9 218 218 0 0 0 23.5-25.4l12.4-15 2.6-2.9 2.2-2.6h27.1c40-85.7 14.7-212.8-67.1-266.7C335.3-.6 317.3 0 287.9 0m-43 61.2c10.8 35.2 35.2 64.2 76.6 85.6q29.8 22.1 57.6 53c3.3-13.6-9.3-30.1-24.5-47a74 74 0 0 1 36.2 35.4c10.7 21.8 10.6 40 7 63.7q-1.5 10.2-4.2 19.6a7 7 0 0 0-3 2l-5 6-2.6 3-12.4 15c-9.5 11.4-19 22.8-31.2 31a77 77 0 0 1-45.3 13.2c-18 0-31.5-5.1-42.7-12.6a157 157 0 0 1-30.3-29l-22.7-26.4q-1.3-1.5-3.3-2.1c-22.4-77.7-11.5-149.2 49.7-210.4m318.3 394.3 11.8 11.7a8 8 0 0 1 0 11.3l-9.5 9.5a63 63 0 0 1 5.9 15.7h12.3a8 8 0 0 1 8 8v16.6a8 8 0 0 1-8 8h-13.4a63 63 0 0 1-7 15.3l8.7 8.7a8 8 0 0 1 0 11.3l-11.8 11.7a8 8 0 0 1-11.2 0l-9.5-9.5a63 63 0 0 1-15.7 6V592a8 8 0 0 1-8 8H499a8 8 0 0 1-8-8v-13.4a63 63 0 0 1-15.2-7l-8.7 8.8a8 8 0 0 1-11.3 0L444 568.6a8 8 0 0 1 0-11.3l9.5-9.5a63 63 0 0 1-5.9-15.7h-12.3a8 8 0 0 1-8-8v-16.6a8 8 0 0 1 8-8h13.5a63 63 0 0 1 7-15.3l-8.8-8.7a8 8 0 0 1 0-11.2l11.8-11.8a8 8 0 0 1 11.3 0l9.5 9.5a63 63 0 0 1 15.7-6v-12.2a8 8 0 0 1 8-8h16.6a8 8 0 0 1 8 8v13.4a63 63 0 0 1 15.2 7l8.7-8.8a8 8 0 0 1 11.3 0zM509.5 485a32.8 32.8 0 1 1 0 65.6 32.8 32.8 0 0 1 0-65.6"/>'
		],
		
		'wpva' => [
			'box' => '0 0 122.88 110.29',
			'body' => '<path d="m7.59 71.54 1.6-8.71q2.07-.2 4.04-.76 2.04-.59 3.99-1.49l5.66 6.86zm115.29-35.91c-3.17 6.17 2.45 14.47-3.99 19.02a8 8 0 0 1-6.33 1.24 5.3 5.3 0 0 1-3.09-2.12c-2.96-4.25-.48-9.5 2.99-12.61 3.2-2.86 7.47-4.53 10.42-5.53M96.55 68.44a26 26 0 0 0 9.67 5.88l-6.06 8.64c2.29.64 4.28 1.32 5.74 2.14a18 18 0 0 1 5.58 4.72c3.21 4.24 9.79 19.65-.88 20.46H5.84c-10.66-.81-4.09-16.22-.88-20.46a17.5 17.5 0 0 1 5.58-4.72l.55-.29-3.04-11.38 15.36-4.12 3.01 11.22c6.03-1.41 11.94-3.05 14.95-5.76 5.51 16.21 28.53 16.81 33.7 0 3.04 2.74 9.06 4.38 15.15 5.81zm10.66-12.35c.92 1.24 2.98 2.82 4.98 2.97l-5.01 13.53c-3.86-1.27-7.28-3.12-9.93-5.95 3.93-3.94 6.32-6.19 9.96-10.55M13.12 83.95q1.1-.4 2.38-.77l-2.1-7.84a1.25 1.25 0 0 0-1.53-.88c-.66.18-1.06.87-.88 1.53zm4.34-1.31 2.42-.6-2.11-7.87a1.25 1.25 0 0 0-1.53-.88c-.66.18-1.06.87-.88 1.53zm4.41-1.06 2.43-.56L22.15 73a1.25 1.25 0 0 0-1.53-.88c-.66.18-1.06.87-.88 1.53zM9.73 59.87l1.26-6.85 4.33 5.25a23 23 0 0 1-5.59 1.6m27.41-18.69a5 5 0 0 0-2.63.69q-.51.34-.75.87-.27.59-.25 1.4c.05 1.59.88 3.66 2.48 6.05l.02.03 5.21 8.29c2.09 3.32 4.28 6.71 7 9.2a14.3 14.3 0 0 0 9.99 4.02 14.7 14.7 0 0 0 10.57-4.2c2.81-2.63 5.02-6.23 7.21-9.83l5.87-9.67c1.09-2.5 1.49-4.17 1.24-5.15q-.23-.86-1.89-.92l-.71-.01-.82.05q-.24.02-.45-.03a8 8 0 0 1-1.61-.09l2.01-8.9c-14.92 2.35-26.07-8.73-41.84-2.22l1.14 10.49q-.94.05-1.79-.07m46.09-1.87a3.8 3.8 0 0 1 2.75 2.84c.42 1.64-.04 3.96-1.43 7.12l-.09.17-5.94 9.78c-2.29 3.77-4.61 7.55-7.71 10.45a17.5 17.5 0 0 1-12.58 4.99 17 17 0 0 1-11.98-4.8c-3.01-2.76-5.32-6.31-7.51-9.8l-5.21-8.28c-1.91-2.84-2.9-5.44-2.96-7.57q-.05-1.5.51-2.71.59-1.27 1.79-2.08.57-.38 1.26-.64c-.34-4.49-.46-10.16-.25-14.9a20 20 0 0 1 .64-3.37c1.33-4.76 4.67-8.59 8.8-11.22a28 28 0 0 1 7.38-3.28c1.65-.47-1.41-5.76.3-5.93 8.27-.85 21.66 6.7 27.43 12.95 2.89 3.13 4.71 7.28 5.1 12.77z" fill-rule="evenodd" clip-rule="evenodd"/>'
		],

		'wpwms' => [
			'box' => '0 0 450 450',
			'body' => '<path d="M191.63.83c-63.87 6.4-120.35 40.13-157.68 94.1C19.79 115.36 5.1 147.85.85 168.2c-.57 2.74-.93 5-.83 5s.84-1.3 1.57-2.85c6.61-13.4 19.61-34.22 28.85-46.1C36.78 116.05 51.2 101 57.9 95.5c25.44-20.71 54.38-30.23 81.81-27 26.01 3.06 49.3 14.68 69.17 34.48 7.24 7.21 11.33 12.21 16.41 19.96 7.03 10.6 11.7 20.71 14.79 31.96 1.57 5.75 1.89 7.64 3.72 20.98 4.93 35.13 9.5 53.8 17.47 71.18 12.27 26.68 30.25 41.48 55.16 45.35 16.47 2.53 43.1-1.13 61.62-8.45 17.83-7.04 32.83-19.36 41.27-33.94 4.3-7.48 6.82-14.48 8.65-24.48 1.26-6.78 1.26-25.13-.05-33.52-6.45-42.5-21.13-76.99-46.67-109.75-6.71-8.61-22.81-25.13-31.26-32.07C315.18 21.54 275.43 4.86 232.33.77c-10.28-.97-30.84-.97-40.7.06"/><path d="M112.19 146.9c-17.73 1.12-31.52 4.51-45.36 11.13-6.2 2.96-15.47 9.52-20.61 14.58-2.68 2.58-8.02 9.41-10.44 13.29-3.67 5.86-6.34 12.7-8.23 20.71-2.41 10.44-2.67 12.75-2.67 24 0 41.26 13 84.3 36.34 120.08 28.42 43.63 70.48 75.37 119.61 90.38 8.76 2.64 16.36 4.57 20.61 5.17.95.16 2.78.48 4.1.8 1.35.33 3.66.7 5.13.81 1.47.16 4.72.6 7.18 1.02 5.4.92 10.54 1.13 24.65 1.13 13.74 0 19.46-.21 23.13-.86 3.25-.54 7.13-1.07 8.33-1.13.42 0 1.84-.27 3.15-.54 2.26-.48 3.46-.7 7.19-1.23.89-.16 2.3-.54 3.04-.81.78-.32 1.57-.43 1.83-.27s.58.05.79-.27.52-.43.79-.27 1.04.06 1.78-.27c.79-.27 1.94-.64 2.57-.75 4.04-.8 17.25-5 24.23-7.75 47.4-18.56 87-53.2 112.22-98.24 3.88-6.99 10.64-20.82 13.1-26.95 2.05-5.06 5.62-15.92 5.36-16.25-.1-.05-2.47 3.5-5.3 7.91-11.06 17.38-20.56 29.43-33.82 43.04-28.37 29-57.9 43.2-89.73 43.26-16.26 0-30.57-3.34-45.36-10.66-12.9-6.4-22.34-13.23-32.98-23.94-15.74-15.87-26.33-33.68-31.78-53.74-2.05-7.43-3-14-3.67-25.24-1.32-22.65-2.1-31.52-3.73-42.39-4.66-31.31-13.58-52.24-28.47-66.87-11.54-11.35-25.38-17.27-44-18.89-7.34-.64-8.86-.64-18.98 0"/>'
		],

		'wpwp' => [
			'box' => '0 0 600 600',
			'body' => '<path fill-rule="nonzero" d="M137 0h255a11 11 0 0 1 8.6 4.3l129.7 140.4a11 11 0 0 1 2.9 7.2v378a70 70 0 0 1-20.7 49.4A70 70 0 0 1 463 600H137.1a70 70 0 0 1-49.6-20.6A70 70 0 0 1 67 529.8V70.2A70 70 0 0 1 137 0M88.3 397.2h423.4v-224c-35.8 0-84 5.3-113-19.5a74 74 0 0 1-24.8-53.3l-.1-1.5V21.4H137a48.6 48.6 0 0 0-48.8 48.8zM511.7 419H88.3v111c0 13.3 5.5 25.5 14.4 34.3 8.8 8.9 21 14.4 34.4 14.4h325.8a49 49 0 0 0 48.8-48.8zm-65-122.5h-18.4v21.4h-28.4v-88.6h44.7q30.5 0 30.5 32.8 0 18-8 26.6-3 3.3-8.2 5.6t-12.2 2.2M428.3 252v21.8h6.5q5.1 0 7.4-1t2.4-5V258q0-3.9-2.4-5-2.3-1-7.4-1zM317 318v-88.7h46q12.7 0 18.2 5t5.5 14.4c0 9.5-1.2 11.3-3.5 14.7q-3.5 5.2-9.3 6.8v.8q17.2 3 17.2 23.4 0 10.6-5.7 17t-17.5 6.5zm39.4-35.4h-11V297h11q5.9 0 5.9-7.2c0-7.3-2-7.3-5.9-7.3m-2-33.9h-9v13.2h8.8q5.4 0 5.4-6.6t-5.3-6.6m-54.6 35.8h-28.4v10.8H306v22.6h-63v-88.6h62.3l-3.5 22.7h-30.5v12h28.4zm-92.4-55.2h29.6L223 317.8h-37l-6.5-32.6h-1.7l-6.4 32.6h-37l-14-88.6h29.7l6.7 49.5h.8l10.2-49.5h21.7l10.1 49.5h.9zm.7 281.4a11 11 0 0 1 0-22h179.5a11 11 0 0 1 0 22zM395.2 30v68.9q1.8 25.1 17.4 38.5c22.3 19.1 67.4 14.3 95.1 14.3z"/>'
		],

	];

	private static function wrap(string $key, string $class= ''): string
	{
		$key = strtolower($key);
		if ($key=== '' || $key === 'wp4t') $svg = self::$svg['404'];
		elseif ($key=== 'wprd') $svg = self::$svg['301'];
		elseif ($key=== 'wpcm') $svg = self::$svg['memcached'];
		elseif ($key=== 'wpcr') $svg = self::$svg['redis'];
		elseif ($key=== 'wpl') $svg = self::$svg['license'];
		elseif ($key=== 'wpo') $svg = self::$svg['rocket'];
		elseif ($key=== 'wpm') $svg = self::$svg['wpmt'];
		elseif ($key=== 'memory_white')
		{
			$svg = self::$svg['memory'];
			$svg['body'] = str_replace('"/>', '" fill="#fff"/>', $svg['body']);
		}
		else $svg = self::$svg[$key];
		return '<svg'. ($class!== '' ? ' class="'.$class.'"' : ''). ' viewBox="' . $svg['box'] . '" fill="currentColor" xmlns="http://www.w3.org/2000/svg">' . $svg['body'] . '</svg>';
	}

	public static function echo(string $key, string $class= ''): void
	{
		static $default_class = 'atec-svg-icon';
		if ($key=== 'wordpress') \ATEC\TOOLS::dash_span($key);
		else echo self::wrap($key, $default_class . ($class!== '' ? ' '.$class : ''));	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
	
	public static function plain(string $key, string $class= ''): string
	{
		return self::wrap($key, $class);
	}
	
	public static function base64(string $key): string
	{
		$svg = self::wrap($key);
		return 'data:image/svg+xml;base64,' . base64_encode($svg);
	}

	public static function styled(string $key, $size=20): string
	{
		$svg = self::wrap($key);
		$svg = str_replace(
			'<svg ',
			'<svg style="display: inline-flex; width: '.$size.'px; max-height: '.$size.'px; vertical-align: middle;" ',
			$svg);
		return $svg;
	}
	
}
?>