<?php
defined('ABSPATH') || exit;

use ATEC\FS;
use ATEC\INIT;

(function() {

	$notice=[];

	if (!FS::exists(FS::htaccess_path())) INIT::build_notice($notice, 'warning', '/.htaccess is unavailable but required by atec-webp');
	else
	{
		$success = true;
		$install_result = FS::install_default_files(__DIR__, 'wpwp', $success);
		$notice = $install_result['notice'];
		
		$arr = ['htaccess.txt' => '.htaccess', 'img2webp.php.txt' => 'img2webp.php'];
		$success = true;
		FS::install_files(__DIR__, '', $arr, $success);
		if (!$success) INIT::build_notice($notice, '', 'Failed to copy required files to the uploads folder');
	}

	if (!empty($notice)) INIT::set_admin_debug('wpwp', $notice);

})();
?>