<?php
namespace ATEC_WPWP;
defined('ABSPATH') || exit;

use ATEC\CHECK;
use ATEC\FS;
use ATEC\INIT;
use ATEC\TOOLS;

final class Cpanel {

private static $img_url, $img_arr, $total_size, $total_count, $total_size_saved, $total_webp_size, $total_webp_count, $total_x_webp_size, $total_x_webp_count;

private static function imgIcon($ext, $size=16) 
{
	echo '<img style="height: ', esc_attr($size), 'px; vertical-align: middle; margin-bottom:2px; margin-top:-1px;" src="', esc_url(self::$img_url.$ext.'-file-icon.svg') , '">';	// phpcs:ignore
}

private static function getImgSize($path)
{
	foreach(self::$img_arr as $a) { if ($a['path']=== $path) return $a['size']; }
	return 0;
}

private static function delete_files($dir)
{
	// @codingStandardsIgnoreStart | WP dirlist requires to much memory, this recursive function requires much less.
	$dir_handle = opendir($dir);
	if (is_resource($dir_handle))
	{
		while(($f = readdir($dir_handle)) == true)
		{
			if ($f=== '.' || $f=== '..') continue;
			$full_path= $dir.$f;
			if (is_dir($full_path)) self::delete_files($full_path.DIRECTORY_SEPARATOR);
			else { if (str_ends_with($f, '.Xwebp.webp')) FS::unlink($full_path); }
		}
		closedir($dir_handle);
	}
	// @codingStandardsIgnoreEnd
}

private static function image_array($root, $dir, $ymFolder)
{
	if ($ymFolder) { $reg = '/(\d+)\/(\d+)\/.*\.(jpe?g|png|bmp|gif|webp)/i'; $m=3; }
	else { $reg = '/.*\.(jpe?g|png|bmp|gif|webp)/i'; $m=1; }
	
	// @codingStandardsIgnoreStart | WP dirlist requires to much memory, this recursive function requires much less.
	$dir_handle = opendir($dir);
	if (is_resource($dir_handle))
	{
		while(($f = readdir($dir_handle)) == true)
		{
			if ($f=== '.' || $f=== '..') continue;
			$full_path= $dir.$f;
			if (is_dir($full_path)) self::image_array($root, $full_path.DIRECTORY_SEPARATOR, $ymFolder);
			else
			{
				preg_match($reg, $full_path, $matches);
				if (!empty($matches))
				{
					$size=FS::size($full_path);
					self::$img_arr[]= array('path'=>str_replace($root, '', $full_path), 'size'=>$size, 'ext'=>$matches[$m]);
					if ($matches[$m]!== 'webp') { self::$total_size+= $size; self::$total_count++; }
					else
					{
						self::$total_webp_size+= $size; self::$total_webp_count++;
						if (str_ends_with($f, '.Xwebp.webp')) { self::$total_x_webp_count++; }
					}
				}
			}
		}
		closedir($dir_handle);
	}
	// @codingStandardsIgnoreEnd
}

public static function init($una, $license_ok) 
{

	self::$img_url = plugins_url( '/assets/img/icons/', __DIR__);

	$settings 				= INIT::get_settings('wpwp');
	$root 					= ABSPATH;
	$upload_basedir 	= FS::upload_basedir();
	$replace_dir			= '#';
	$site_url 				= INIT::site_url();

	switch ($una->action)
	{
		case 'delete_all_webp':
			set_time_limit(600); @ini_set('max_execution_time', 600); // phpcs:ignore
			self::delete_files($root.DIRECTORY_SEPARATOR);
			break;
			
		case 'active':
			$settings['active'] = !($settings['active'] ?? 0); 
			INIT::update_settings('wpwp', $settings); 
			TOOLS::lazy_require_class(__DIR__, 'atec-wpwp-htaccess.php', 'ATEC_WPWP\\Htaccess', $settings['active'], false);
			break;
	}
	
	$option = INIT::bool($settings['active'] ?? 0);
	
	$serverSoftwareLow = strtolower(INIT::_SERVER('SERVER_SOFTWARE'));
	$serverSoftware = '';
	if (str_contains($serverSoftwareLow, 'apache')) $serverSoftware= 'Apache';
	elseif (str_contains($serverSoftwareLow, 'litespeed')) $serverSoftware= 'LiteSpeed';
	elseif (str_contains($serverSoftwareLow, 'nginx')) $serverSoftware= 'NGINX';

	$gdEnabled=(extension_loaded('gd') && function_exists( 'gd_info'));
	$gdWebP= $gdEnabled?gd_info()['WebP Support']:false;

	$imagickEnabled=extension_loaded('imagick') && class_exists('Imagick');
	$imagickWebP= $imagickEnabled?(!empty(\Imagick::queryFormats('WEBP'))):false;

	$webpStr= 'WebP';
	$ymFolder= get_option('uploads_use_yearmonth_folders', false);

	$willWork=true;
	if (strpos(strtolower(PHP_OS_FAMILY), 'win')===0) 
		{ $willWork=false; TOOLS::msg(false, 'Windows OS does not support .htaccess rewrite rules, which are required for atec-WebP to work'); }
	elseif (!FS::exists(FS::htaccess_path())) 
		{ $willWork=false; TOOLS::msg(false, 'Apache rewrite rules are required but the .htaccess file is not readable'); }
	if (!in_array($serverSoftware,['Apache', 'LiteSpeed']))
	{
		if ($serverSoftware== 'NGINX') 
		{ 
			TOOLS::msg('warning', 'NGINX server detected. If NGINX is configured as a reverse proxy for Apache, the .htaccess rules will still apply. Otherwise, a custom NGINX configuration is required. Please refer to the ‘NGINX .conf’ help button for details.');
		}
		else 
		{ $willWork=false; TOOLS::msg(false, 'Apache or LiteSpeed webserver is required'); }
	}

	if ($willWork)
	{
		if (($gdEnabled && $gdWebP) || ($imagickEnabled && $imagickWebP))
		{
			$arr[$serverSoftware] = in_array($serverSoftware,['Apache', 'LiteSpeed'], true);
			$arr['GD & WebP'] = $gdEnabled && $gdWebP;
			$arr['Imagick & WebP'] = $imagickEnabled && $imagickWebP;

			TOOLS::little_block_multi($una, 'WebP Support', [], '', $arr);
			
			TOOLS::div('btn');

				CHECK::checkbox_button_div($una, 'active', '', 'WebP active', $option);
				TOOLS::button_confirm($una, 'delete_all_webp', '', '#trash All "atec .Xwebp" files');

				$selectedLibrary = $imagickEnabled && $imagickWebP ? 'ImageMagick' : 'GD';
				if ($option) TOOLS::msg(true, $selectedLibrary.' in use');
				else TOOLS::msg('info', $selectedLibrary.' will be used');

				echo	
				'<div class="atec-row-right">';

					TOOLS::help('How it works',
						'On activation, the .htaccess file will be modified to redirect .png, .jpg and .jpeg files to their .webp equivalent.<br>
						If the .webp version does not exist, the request will be redirected to a script that generates the .webp file.<br>
						atec-WebP works on-demand, no configuration or batch conversion required.');

					TOOLS::help('Savings', 'This is the sum of the size difference between the .web version and the original file.');
					
						if ($serverSoftware === 'NGINX') 
						{
							TOOLS::help('NGINX .conf',
								'NGINX does not support <code>.htaccess</code> files. '.
								'To enable WebP delivery, you need to manually add a <code>location</code> block to your NGINX server configuration, typically inside your site’s <code>server { ... }</code> block.
								<br><br>
								You can download a ready-to-use config file here:
								<a href="' . esc_url(plugins_url('install/atec-webp-nginx.conf', dirname(__FILE__))) . '" target="_blank" rel="noopener noreferrer">webp-nginx.conf</a>.'
							);
						}
					
				echo
				'</div>';
				
			TOOLS::div(-1);

			if (!$license_ok)  TOOLS::pro_feature($una, 'for PNG, GIF & BMP support', true);

		}
		else TOOLS::msg(false, 'GD or ImageMagick extension required, with WebP support');
	}

	$site_host 	= INIT::site_host();
	$isCDN 		= false;
	if ($site_host!== 'localhost')
	{
		$ns = dns_get_record($site_host, DNS_NS);
		foreach((array) $ns as $n) if (str_contains($n['target'], 'cloudflare')) { $isCDN=true; break; };
	}

	if ($isCDN) TOOLS::msg('info', 'It looks like you are using a CDN.<br>If so, the rewrite rules to serve .webp files will not be effective – unless you exclude image files from caching.<br>Please check the response header to see whether .webp files are actually handled by your server – or delivered by a CDN');

	echo
	'<div class="atec-box-white atec-mb-20">
		<strong><span class="atec-fs-16 ',esc_attr(TOOLS::dash_class('open-folder')), '"></span>Folder: </strong> ', esc_attr($upload_basedir), '/*<br>
		<small>Using ', $ymFolder?'year/month' : 'custom', ' folder structure.</small>
	</div>';

	self::$img_arr=[];
	self::$total_size=0; 
	self::$total_count=0; 
	self::$total_size_saved=0;
	self::$total_webp_size=0; 
	self::$total_webp_count=0;
	self::$total_x_webp_size=0; 
	self::$total_x_webp_count=0;

	self::image_array($upload_basedir.DIRECTORY_SEPARATOR, $upload_basedir.DIRECTORY_SEPARATOR, $ymFolder);

	echo
	'<div>
	
		<div class="atec-dilb atec-mr-5">';
			TOOLS::table_header();
				echo
				'<tr>
					<td class="atec-label atec-border-right" style="background: #f1fff1aa;">'; self::imgIcon('webp'); echo ' files total:</td>
					<td>',esc_html(number_format(self::$total_webp_count)), '</td>
				</tr>
				<tr>
					<td class="atec-label atec-border-right" style="background: #f1fff1aa;">'; self::imgIcon('webp'); echo ' thereof .Xwebp:</td>
					<td>',esc_html(number_format(self::$total_x_webp_count)), '</td>
				</tr>
				<tr>
					<td class="atec-label atec-border-right">Total size:</td>';
					TOOLS::td_size_format(self::$total_webp_size);
				echo
				'</tr>';
			TOOLS::table_footer();
		echo
		'</div>

		<div class="atec-dilb atec-mr-5">';
			TOOLS::table_header();
				echo
				'<tr class="atec-dn"><td></td></tr>
				<tr>
					<td class="atec-label atec-border-right" style="background: #f1f1ffaa;">';
						foreach(['bmp', 'gif', 'jpg', 'png'] as $icon) self::imgIcon($icon);
						echo ' non .webp files:',
					'</td>
					<td>',esc_html(number_format(self::$total_count)), '</td>
				</tr>
				<tr>
					<td class="atec-label atec-border-right">Total size:</td>';
					TOOLS::td_size_format(self::$total_size);
				echo
				'</tr>';
			TOOLS::table_footer();

		echo
		'</div>

		<div class="atec-dilb atec-mr-5 atec-dn" id="totalSavedDiv">';

			TOOLS::table_header([], '', 'summary');
				echo '<tr><td class="atec-label atec-border-right">Savings</td><td id="totalSaved"></td></tr>';
			TOOLS::table_footer();	
			
		echo
		'</div>

	</div>';

	if ($una->action=== 'details')
	{
		usort(self::$img_arr, function($a, $b) { return strnatcmp(str_replace('.', '#', $a['path']), str_replace('.', '#', $b['path'])); });
		echo
		'<div style="max-height: 50vh; overflow: auto;" class="atec-box-white">';
			TOOLS::table_header(['', 'Filename', 'Thumbnails'], 'tableImages', 'atec-fit');

			$thumbReg 	= '/(.*)(\-+[\d]+x+[\d]+)(.*)/i';
			$scaled			= '/(\-scaled)/i';

			$lastFile 		= '';
			$lastSize 		= 0;
			$isOpen		= false;
			$uploads_sub_dir = str_replace(ABSPATH, '', $upload_basedir);

			foreach (self::$img_arr as $a)
			{
				$isWebP= $a['ext']=== 'webp';
				$basename= str_replace('-scaled', '', $a['path']);
				preg_match($thumbReg, $basename, $matches);
				if (isset($matches[3])) $basename= $matches[1].$matches[3];

				if ($isOpen)
				{
					if ($basename=== $lastBasename || str_replace(['.Xwebp.webp', '.webp'], '', $basename)=== $lastBasename)
					{
						echo '<span class="thumb'.($isWebP?'WebP' : '').'">';
						if ($isWebP)
						{
							$size= self::getImgSize(str_replace(['.Xwebp.webp', '.webp'], '', $a['path']));
							if ($size!==0) self::$total_size_saved+=($size-$a['size']);
							self::imgIcon('webp',14); echo ' ';
						}
						echo esc_html(ltrim($matches[2]??'', '-'));
						echo '</span>';
					}
					else
					{
						echo '</td></tr>'; $isOpen=false;
					}
				}

				if (!$isOpen)
				{
					$img_url= $site_url.DIRECTORY_SEPARATOR.$uploads_sub_dir.DIRECTORY_SEPARATOR.$a['path'];
					echo
					'<tr>
						<td class="thumb'.($isWebP?'WebP' : '').'">'; self::imgIcon($a['ext'],14); echo '</td>
						<td class="atec-border-right">
							<span class="atec-blue atec-cursor" onclick="lightBox(\'', esc_url($img_url), '\');">', esc_html($a['path']), '</span>
						</td>
						<td>';
					$lastBasename= $basename; $isOpen=true;
				}
			}

			TOOLS::table_footer();
			echo '
		</div>';

		TOOLS::reg_inline_script('wpwp_totalSaved', 'jQuery("#totalSavedDiv").removeClass("atec-dn"); jQuery("#totalSaved").html("'.wp_kses_post(TOOLS::size_format(self::$total_size_saved)).'");', true);
	}
	else if (!empty(self::$img_arr)) TOOLS::button($una, 'details', '', '#format-gallery Show all images', true);

	TOOLS::reg_inline_script('wpwp_esc', 'jQuery(document).keyup(function(e) { if (e.keyCode == 27 && instance) { instance.close(); } });', true);
	
}

}
?>