<?php
namespace ATEC_WPWP;
defined('ABSPATH') || exit;

use ATEC\FS;
use ATEC\TOOLS;

final class Htaccess {

public static function init($enable, $deactivation) 
{
	$upload_basedir = FS::upload_basedir();

	$htaccess_path = $upload_basedir.'/.htaccess';
	$htaccess = FS::get($htaccess_path);
	
	$reg = '/#{0,4} BEGIN atec-webp.*?#{0,4} END atec-webp\s*/s';

	$htaccess = preg_replace($reg, "$1", $htaccess);
	
	TOOLS::lazy_require(__DIR__, 'atec-wpwp-htaccess-pro.php');
	$regImg = defined('ATEC_WPWP_PRO_REG') ? ATEC_WPWP_PRO_REG : 'jpe?g';
	
	if ($enable) 
	{
		$redirect = FS::get(dirname(__DIR__).'/install/htaccess.txt');
		$htaccess = $redirect."\n\n".$htaccess;
		$htaccess = preg_replace('/[\n]{3,}/m', "\n\n", $htaccess);
	}
	
	$result= $htaccess!== ''?FS::put($htaccess_path, $htaccess):false;
	if (!$deactivation) TOOLS::badge($result, 'Writing ‘.htaccess’#succeeded', 'failed');
}

}
?>